/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.validators;

import java.util.HashMap;
import java.util.Map;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;

/**
 * A number interval form validator
 */
public class NumberIntervalFormValidator extends AbstractIntervalFormValidator<Number>
{
    /**
     * The constructor
     * @param regexp the regexp
     * @param mandatory mandatory
     * @param min the min value
     * @param max the max value
     */
    public NumberIntervalFormValidator(String regexp, boolean mandatory, Number min, Number max)
    {
        super(regexp, mandatory, min, max);
    }

    @Override
    protected boolean isLessThan(Number value, Number min)
    {
        if (value.doubleValue() < min.doubleValue())
        {
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMoreThan(Number value, Number max)
    {
        if (value.doubleValue() > max.doubleValue())
        {
            return true;
        }
        return false;
    }

    @Override
    protected I18nizableText getIntervalError(Number min, Number max)
    {
        Map<String, I18nizableTextParameter> i18nParams = new HashMap<>();
        i18nParams.put("minValue", new I18nizableText(min.toString()));
        i18nParams.put("maxValue", new I18nizableText(max.toString()));
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_VALIDATOR_NUMBER_INTERVAL_ERROR", i18nParams);
    }
}
