/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

/**
 * Interface to update questions or pages after a form copy
 *
 */
public interface CopyFormUpdater
{
    /**
     * Update form after copy
     * @param originalForm the original form
     * @param createdForm the new form
     */
    public void updateForm (Form originalForm, Form createdForm);
    
    /**
     * Update page after copy
     * @param originalFormPage the original form page
     * @param createdFormPage the new form page
     */
    public void updateFormPage (FormPage originalFormPage, FormPage createdFormPage);
    
    /**
     * Update question after copy
     * @param originalFormQuestion the original form question
     * @param createdFormQuestion the new form question
     */
    public void updateFormQuestion (FormQuestion originalFormQuestion, FormQuestion createdFormQuestion);
    
}
