/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

/**
 * This class generates the ids of the extensions used for each workflow tab
 */
public class FormEntriesWorkflowsGenerator extends AbstractFormEntriesWorkflowsGenerator
{
    /** The beginning of the id of the workflow steps extension */
    private static final String __FORM_WORKFLOW_STATE_EXTENSION_ID_PREFIX = "entry-form-workflow-steps.";

    @Override
    protected String _getPrefixWorkflowButton()
    {
        return __FORM_WORKFLOW_STATE_EXTENSION_ID_PREFIX;
    }
    
    @Override
    protected String _getRibbonTabKeyToOverride()
    {
        return "plugin.forms:RIBBON_TABS_TAB_FORM_ENTRIES_LABEL";
    }
    
    @Override
    protected String _getPrefixWorkflowName()
    {
        return "entry-form-";
    }
    
    @Override
    protected String _getDefaultWorkflowButtonsId()
    {
        return "default-form-workflow-steps";
    }
}
