/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.actions.AbstractProcessFormAction;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.helper.FormWorkflowHelper;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.helper.ScheduleOpeningHelper;
import org.ametys.plugins.forms.question.types.RestrictiveAwareQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class ProcessFormAction
extends AbstractProcessFormAction {
    public static final String CAPTCHA_KEY = "ametys-captcha";
    protected FormWorkflowHelper _formWorkflowHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected LimitedEntriesHelper _limitedEntriesHelper;
    protected FormMailHelper _formMailHelper;
    protected ScheduleOpeningHelper _scheduleOpeningHelper;
    protected PageHelper _pageHelper;
    protected FormEntryDAO _formEntryDAO;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._formWorkflowHelper = (FormWorkflowHelper)((Object)serviceManager.lookup(FormWorkflowHelper.ROLE));
        this._limitedEntriesHelper = (LimitedEntriesHelper)((Object)serviceManager.lookup(LimitedEntriesHelper.ROLE));
        this._formMailHelper = (FormMailHelper)((Object)serviceManager.lookup(FormMailHelper.ROLE));
        this._scheduleOpeningHelper = (ScheduleOpeningHelper)((Object)serviceManager.lookup(ScheduleOpeningHelper.ROLE));
        this._pageHelper = (PageHelper)serviceManager.lookup(PageHelper.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)serviceManager.lookup(FormEntryDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Map<String, String> result = this._processForm(request);
        if (result == null) {
            return null;
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    @Override
    protected List<FormQuestion> _getRuleFilteredQuestions(Request request, Form form, FormQuestionDAO.FormEntryValues entryValues, Optional<Long> currentStepId) {
        return this._formQuestionDAO.getRuleFilteredQuestions(form, entryValues, currentStepId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> _processForm(Request request) {
        HashMap<String, String> result;
        block19: {
            result = new HashMap<String, String>();
            String formId = request.getParameter("formId");
            if (StringUtils.isNotEmpty((CharSequence)formId)) {
                String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
                try {
                    RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
                    Form form = (Form)this._resolver.resolveById(formId);
                    if (!this._rightManager.currentUserHasReadAccess((Object)form)) {
                        throw new AccessDeniedException("Can't answer to the form data without convenient right");
                    }
                    UserIdentity user = this._currentUserProvider.getUser();
                    String clientIp = this._limitedEntriesHelper.getClientIp(request);
                    ArrayListMultimap formErrors = ArrayListMultimap.create();
                    boolean canUserSubmit = this._limitedEntriesHelper.canUserSubmit(form, user, clientIp);
                    boolean isOpen = this._scheduleOpeningHelper.getStatus(form) == ScheduleOpeningHelper.FormStatus.OPEN;
                    boolean isConfigured = this._formDAO.isFormConfigured(form);
                    if (canUserSubmit && isOpen && isConfigured) {
                        View filteredEntryView;
                        Map formInputValues;
                        FormEntry entry;
                        block18: {
                            if (!this._checkCaptcha(request, form, (Multimap<String, I18nizableText>)formErrors)) {
                                request.setAttribute("form", (Object)form);
                                request.setAttribute("form-errors", (Object)formErrors);
                                Map<String, String> map = null;
                                return map;
                            }
                            entry = this._entryDAO.createEntry(form);
                            try {
                                Optional<Long> currentStepId = form.hasWorkflow() ? Optional.of(RestrictiveAwareQuestionType.INITIAL_WORKFLOW_ID) : Optional.empty();
                                View entryView = View.of((Collection)entry.getModel());
                                formInputValues = this._foAmetysObjectCreationHelper.getFormValues(request, (ViewItemContainer)entryView, "", (Multimap)formErrors);
                                this._adaptFormValuesForChoiceList(form, formInputValues);
                                filteredEntryView = this._getRuleFilteredEntryView(request, form, entryView, new FormQuestionDAO.FormEntryValues(formInputValues, null), currentStepId);
                                formErrors.putAll(this._foAmetysObjectCreationHelper.validateValues(formInputValues, filteredEntryView));
                                for (FormQuestion question : form.getQuestions()) {
                                    if (!filteredEntryView.hasModelViewItem(question.getNameForForm())) continue;
                                    question.getType().validateEntryValues(question, formInputValues, (Multimap<String, I18nizableText>)formErrors, currentStepId, new HashMap<String, Object>());
                                }
                                if (formErrors.isEmpty()) break block18;
                                request.setAttribute("form", (Object)form);
                                request.setAttribute("form-errors", (Object)formErrors);
                                Iterator<FormQuestion> iterator = null;
                                return iterator;
                            }
                            catch (Exception e) {
                                request.setAttribute("form", (Object)form);
                                request.setAttribute("form-errors", (Object)formErrors);
                                this.getLogger().error("An error occured while storing entry", (Throwable)e);
                                Map<String, String> map = null;
                                RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
                                return map;
                            }
                        }
                        entry.synchronizeValues((ViewItemAccessor)filteredEntryView, formInputValues);
                        this._handleComputedValues(form.getQuestions(), entry, false);
                        entry.setUser(this._currentUserProvider.getUser());
                        entry.setIP(clientIp);
                        entry.setSubmitDate(ZonedDateTime.now());
                        entry.setActive(true);
                        this._setEntryId(entry);
                        this._formWorkflowHelper.initializeWorkflow(entry);
                        form.saveChanges();
                        this._sendEmails(entry);
                        if (form.isQueueEnabled()) {
                            int totalSubmissions = form.getActiveEntries().size();
                            long rankInQueue = (long)totalSubmissions - form.getMaxEntries().get();
                            result.put("isInQueue", String.valueOf(rankInQueue > 0L));
                            if (rankInQueue > 0L) {
                                result.put("rankInQueue", String.valueOf(rankInQueue));
                            }
                        }
                        break block19;
                    }
                    if (!canUserSubmit) {
                        formErrors.put((Object)"entries-limit-reached", (Object)new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRIES_LIMIT_REACHED_ERROR"));
                        request.setAttribute("form", (Object)form);
                        request.setAttribute("form-errors", (Object)formErrors);
                    }
                    if (!isOpen) {
                        formErrors.put((Object)"scheduled-not-open", (Object)new I18nizableText("plugin.forms", "PLUGINS_FORMS_OPENING_SCHEDULE_PROCESS_ERROR"));
                        request.setAttribute("form", (Object)form);
                        request.setAttribute("form-errors", (Object)formErrors);
                    }
                    Map<String, String> map = null;
                    return map;
                }
                finally {
                    RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
                }
            }
        }
        return result;
    }

    protected boolean _checkCaptcha(Request request, Form form, Multimap<String, I18nizableText> formErrors) {
        String zoneItemId = request.getParameter("ametys-zone-item-id");
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        if (!this._isFormOnZoneItem(form, zoneItemId)) {
            throw new AccessDeniedException("The form '" + form.getId() + "' doesn't belong to the zone item '" + zoneItemId + "'");
        }
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        Site site = form.getSite();
        String captchaPolicy = (String)site.getValue("display-captcha-policy");
        if (this._pageHelper.isCaptchaRequired(sitemapElement)) {
            String captchaValue = request.getParameter(CAPTCHA_KEY);
            String captchaKey = request.getParameter("ametys-captcha-key");
            if (!CaptchaHelper.checkAndInvalidate((String)captchaKey, (String)captchaValue)) {
                formErrors.put((Object)CAPTCHA_KEY, (Object)new I18nizableText("plugin.forms", "PLUGINS_FORMS_ERROR_CAPTCHA_INVALID"));
                return false;
            }
        } else if ((captchaPolicy == null || "restricted".equals(captchaPolicy)) && !this._rightManager.currentUserHasReadAccess((Object)sitemapElement)) {
            throw new AccessDeniedException("The user try to answer to form '" + form.getId() + "' which belong to an other zone item '" + zoneItemId + "'");
        }
        return true;
    }

    private boolean _isFormOnZoneItem(Form form, String zoneItemId) {
        AmetysObjectIterable<ModifiableZoneItem> zoneItems = this._formDAO.getFormZoneItems(form.getId(), form.getSiteName());
        return zoneItems.stream().filter(z -> z.getId().equals(zoneItemId)).findAny().isPresent();
    }

    protected void _setEntryId(FormEntry entry) {
        List<FormEntry> formEntries = this._formEntryDAO.getFormEntries(entry.getForm(), false, List.of(new FormEntryDAO.Sort("ametys-id", "descending")));
        Long entryId = formEntries.isEmpty() ? 1L : formEntries.get(0).getEntryId() + 1L;
        entry.setEntryId(entryId);
    }

    protected void _sendEmails(FormEntry entry) {
        Form form = entry.getForm();
        Optional<String[]> adminEmails = form.getAdminEmails();
        Optional<String> otherAdminEmails = form.getOtherAdminEmails();
        if (adminEmails.isPresent() || otherAdminEmails.isPresent()) {
            String[] emailsAsArray = this._formMailHelper.getAdminEmails(form, entry);
            this._formMailHelper.sendEmailsForAdmin(form, entry, emailsAsArray);
            if (form.isEntriesLimited()) {
                int totalSubmissions = form.getActiveEntries().size();
                Long maxEntries = form.getMaxEntries().get();
                if (maxEntries == (long)totalSubmissions) {
                    this._formMailHelper.sendLimitationReachedMailForAdmin(entry, emailsAsArray, FormMailHelper.LimitationMailType.LIMIT);
                } else if (form.isQueueEnabled() && form.getQueueSize().isPresent() && form.getQueueSize().get() + maxEntries == (long)totalSubmissions) {
                    this._formMailHelper.sendLimitationReachedMailForAdmin(entry, emailsAsArray, FormMailHelper.LimitationMailType.QUEUE);
                }
            }
        }
        this._formMailHelper.sendReceiptEmail(form, entry);
    }
}

