/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.processing.FormErrors;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormErrorsGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        FormErrors errors = (FormErrors)request.getAttribute("form-errors");
        Form form = errors.getForm();
        Map<String, Field> fields = form.getFieldMap();
        Map<String, List<I18nizableText>> errorMap = errors.getErrors();
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", form.getId());
        atts.addCDATAAttribute("label", form.getLabel());
        atts.addCDATAAttribute("insertionFailed", String.valueOf(errors.hasInsertionFailed()));
        atts.addCDATAAttribute("limitReached", String.valueOf(errors.hasLimitReached()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form-errors", (Attributes)atts);
        for (Map.Entry<String, List<I18nizableText>> fieldErrors : errorMap.entrySet()) {
            String fieldId = fieldErrors.getKey();
            Field field = fields.get(fieldId);
            List<I18nizableText> messages = fieldErrors.getValue();
            atts.clear();
            atts.addCDATAAttribute("id", fieldId);
            atts.addCDATAAttribute("name", field.getName());
            atts.addCDATAAttribute("label", field.getLabel());
            atts.addCDATAAttribute("type", field.getType().toString());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)atts);
            for (I18nizableText message : messages) {
                message.toSAX(this.contentHandler, "error");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"field");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form-errors");
        this.contentHandler.endDocument();
    }
}

