/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.processing.ProcessFormHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.web.repository.content.SharedContent;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class ProcessFormAction
extends ServiceableAction {
    protected FormPropertiesManager _formPropertiesManager;
    protected AmetysObjectResolver _ametysObjectResolver;
    protected SiteManager _siteManager;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvied;
    protected ProcessFormHelper _processFormHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._processFormHelper = (ProcessFormHelper)((Object)serviceManager.lookup(ProcessFormHelper.ROLE));
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._ametysObjectResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
        this._currentUserProvied = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String pluginName = (String)request.getAttribute("pluginName");
        String siteName = (String)request.getAttribute("site");
        Site site = null;
        Content content = (Content)request.getAttribute(Content.class.getName());
        if (content != null && content instanceof SharedContent) {
            siteName = this._getSiteNameFromSharedContent((SharedContent)content);
            site = this._getSiteFromSharedContent((SharedContent)content);
        } else {
            site = this._siteManager.getSite(siteName);
        }
        String id = request.getParameter("ametys-form-id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("A form ID must be provided.");
        }
        Form form = this._formPropertiesManager.getForm(siteName, id);
        if (form == null) {
            throw new IllegalArgumentException("No form definition exists for ID " + id + " and site " + siteName);
        }
        if (content == null) {
            content = (Content)this._ametysObjectResolver.resolveById(form.getContentId());
        }
        if (!this._rightManager.currentUserHasReadAccess((Object)content)) {
            UserIdentity user = this._currentUserProvied.getUser();
            if (user == null) {
                throw new AuthorizationRequiredException();
            }
            throw new AccessDeniedException("User '" + UserIdentity.userIdentityToString((UserIdentity)user) + "' can not post form for content '" + content.getId() + "'");
        }
        ProcessFormHelper.FormInformations formInfos = this._processFormHelper.processForm(form, site, pluginName);
        if (formInfos.getFormErrors().hasErrors()) {
            request.setAttribute("form-errors", (Object)formInfos.getFormErrors());
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)formInfos.getRedirection())) {
            redirector.globalRedirect(false, formInfos.getRedirection());
        }
        return EMPTY_MAP;
    }

    private String _getSiteNameFromSharedContent(SharedContent sharedContent) {
        SharedContent defaultContentContent = (SharedContent)this._ametysObjectResolver.resolveById(sharedContent.getId());
        Content initialContent = defaultContentContent.getInitialContent();
        if (initialContent != null && initialContent instanceof WebContent) {
            return ((WebContent)initialContent).getSiteName();
        }
        return null;
    }

    private Site _getSiteFromSharedContent(SharedContent sharedContent) {
        SharedContent defaultContentContent = (SharedContent)this._ametysObjectResolver.resolveById(sharedContent.getId());
        Content initialContent = defaultContentContent.getInitialContent();
        if (initialContent != null && initialContent instanceof WebContent) {
            return ((WebContent)initialContent).getSite();
        }
        return null;
    }
}

