/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.FormQuestionTypeExtensionPoint;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.sources.ChoiceSourceTypeExtensionPoint;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.impl.ComputedQuestionType;
import org.ametys.plugins.forms.question.types.impl.RichTextQuestionType;
import org.ametys.plugins.forms.repository.CopyFormUpdater;
import org.ametys.plugins.forms.repository.CopyFormUpdaterExtensionPoint;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.parameters.ParametersManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FormQuestionDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = FormQuestionDAO.class.getName();
    public static final String RULES_ROOT = "ametys-internal:form-page-rules";
    protected AmetysObjectResolver _resolver;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected UploadManager _uploadManager;
    protected JSONUtils _jsonUtils;
    protected I18nUtils _i18nUtils;
    protected FormQuestionTypeExtensionPoint _formQuestionTypeExtensionPoint;
    protected ParametersManager _parametersManager;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected ChoiceSourceTypeExtensionPoint _choiceSourceTypeExtensionPoint;
    protected FormDAO _formDAO;
    protected RightManager _rightManager;
    protected CopyFormUpdaterExtensionPoint _copyFormEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
        this._parametersManager = (ParametersManager)serviceManager.lookup(ParametersManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._uploadManager = (UploadManager)serviceManager.lookup(UploadManager.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._formQuestionTypeExtensionPoint = (FormQuestionTypeExtensionPoint)((Object)serviceManager.lookup(FormQuestionTypeExtensionPoint.ROLE));
        this._parametersManager = (ParametersManager)serviceManager.lookup(ParametersManager.ROLE);
        this._formDAO = (FormDAO)((Object)serviceManager.lookup(FormDAO.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._copyFormEP = (CopyFormUpdaterExtensionPoint)((Object)serviceManager.lookup(CopyFormUpdaterExtensionPoint.ROLE));
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    protected UserIdentity _getCurrentUser() {
        return this._currentUserProvider.getUser();
    }

    @Callable(rights={"*"})
    public Map<String, Object> getQuestionProperties(String id) {
        try {
            FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
            return this.getQuestionProperties(question, true);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Can't find question with id: {}. It probably has just been deleted", (Object)id, (Object)e);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", id);
            return infos;
        }
    }

    public Map<String, Object> getQuestionProperties(FormQuestion question, boolean withRight) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean hasTerminalRule = this._hasTerminalRule(question);
        List<String> questionTitlesWithRule = this._getQuestionTitlesWithRule(question);
        List<String> pageTitlesWithRule = this._getPageTitlesWithRule(question);
        properties.put("type", "question");
        properties.put("hasTerminalRule", hasTerminalRule);
        properties.put("pageTitlesWithRule", pageTitlesWithRule);
        properties.put("questionTitlesWithRule", questionTitlesWithRule);
        properties.put("isReadRestricted", question.isReadRestricted());
        properties.put("isModifiable", question.isModifiable());
        properties.put("hasChildren", false);
        properties.put("id", question.getId());
        properties.put("title", question.getTitle());
        properties.put("questionType", question.getType().getId());
        properties.put("pageId", question.getFormPage().getId());
        properties.put("formId", question.getForm().getId());
        properties.put("iconGlyph", question.getType().getIconGlyph());
        properties.put("typeLabel", question.getType().getLabel());
        properties.put("hasEntries", !question.getForm().getEntries().isEmpty());
        properties.put("hasRule", hasTerminalRule || !pageTitlesWithRule.isEmpty() || !questionTitlesWithRule.isEmpty());
        properties.put("isConfigured", question.getType().isQuestionConfigured(question));
        if (withRight) {
            properties.put("rights", this._getUserRights(question));
        } else {
            properties.put("canWrite", this._formDAO.hasWriteRightOnForm(this._currentUserProvider.getUser(), (AmetysObject)question));
        }
        return properties;
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, I18nizableText> getChoiceListQuestionOptions(String questionId) {
        FormQuestion question = (FormQuestion)this._resolver.resolveById(questionId);
        FormQuestionType formQuestionType = question.getType();
        if (formQuestionType instanceof ChoicesListQuestionType) {
            ChoicesListQuestionType type = (ChoicesListQuestionType)formQuestionType;
            return type.getOptions(question);
        }
        return new HashMap<String, I18nizableText>();
    }

    protected Set<String> _getUserRights(FormQuestion question) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this._rightManager.getUserRights(user, (Object)question);
    }

    private boolean _hasTerminalRule(FormQuestion question) {
        return question.getPageRules().stream().map(FormPageRule::getType).filter(t -> t == FormPageRule.PageRuleType.FINISH).findAny().isPresent();
    }

    protected List<String> _getQuestionTitlesWithRule(FormQuestion question) {
        return question.getForm().getQuestionsRule(question.getId()).keySet().stream().map(FormQuestion::getTitle).toList();
    }

    protected List<String> _getPageTitlesWithRule(FormQuestion question) {
        return question.getPageRules().stream().filter(r -> r.getType() != FormPageRule.PageRuleType.FINISH).map(FormPageRule::getPageId).distinct().map(this::_getFormPage).map(FormPage::getTitle).toList();
    }

    private FormPage _getFormPage(String pageId) {
        return (FormPage)this._resolver.resolveById(pageId);
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=1)
    public Map<String, Object> getQuestionParametersDefinitions(String typeID, String formId) throws ProcessingException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        FormQuestionType questionType = (FormQuestionType)this._formQuestionTypeExtensionPoint.getExtension(typeID);
        View view = questionType.getView(form);
        response.put("parameters", view.toJSON(DefinitionContext.newInstance().withEdition(true)));
        response.put("questionNames", form.getQuestionsNames());
        return response;
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getQuestionParametersValues(String questionID) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        FormQuestion question = (FormQuestion)this._resolver.resolveById(questionID);
        FormQuestionType type = question.getType();
        Collection questionModelItems = type.getModel().getModelItems();
        Map parametersValues = this._parametersManager.getParametersValues(questionModelItems, (ModelAwareDataHolder)question, "");
        results.put("values", parametersValues);
        List repeaters = this._parametersManager.getRepeatersValues(questionModelItems, (ModelAwareDataHolder)question, "");
        results.put("repeaters", repeaters);
        results.put("fieldToDisable", this._getFieldNameToDisable(question));
        return results;
    }

    private List<String> _getFieldNameToDisable(FormQuestion question) {
        Form form = question.getForm();
        if (form.getEntries().isEmpty()) {
            return List.of();
        }
        return question.getType().getFieldToDisableIfFormPublished(question);
    }

    @Callable(rights={""})
    public Map<String, Object> createQuestion(String pageId, String typeId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormPage page = (FormPage)this._resolver.resolveById(pageId);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        FormQuestionType type = (FormQuestionType)this._formQuestionTypeExtensionPoint.getExtension(typeId);
        Form form = page.getForm();
        String defaultTitle = this._i18nUtils.translate((I18nizable)type.getDefaultTitle());
        String nameForForm = form.findUniqueQuestionName(defaultTitle);
        FormQuestion question = (FormQuestion)page.createChild(NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)page, (String)nameForForm, (NameHelper.NameComputationMode)NameHelper.NameComputationMode.GENERATED_KEY, (boolean)false), "ametys:form-question");
        question.setNameForForm(nameForForm);
        question.setTypeId(typeId);
        Model model = question.getType().getModel();
        for (ModelItem modelItem : model.getModelItems()) {
            Object defaultValue;
            if (!(modelItem instanceof ElementDefinition) || (defaultValue = ((ElementDefinition)modelItem).getDefaultValue()) == null) continue;
            question.setValue(modelItem.getPath(), defaultValue);
        }
        question.setTitle(form.findUniqueQuestionTitle(defaultTitle));
        page.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", page.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", question.getId());
        result.put("pageId", page.getId());
        result.put("formId", question.getForm().getId());
        result.put("type", typeId);
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> renameQuestion(String id, String newName) {
        HashMap<String, String> results = new HashMap<String, String>();
        FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        question.setTitle(newName);
        question.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", question.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        results.put("id", id);
        results.put("newName", newName);
        results.put("formId", question.getForm().getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> editQuestion(String questionId, Map<String, Object> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, I18nizableText> errors = new HashMap<String, I18nizableText>();
        FormQuestion question = (FormQuestion)this._resolver.resolveById(questionId);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        Form parentForm = question.getForm();
        String questionName = StringUtils.defaultString((String)((String)values.get("name-for-form")));
        if (!question.getType().canBeAnsweredByUser(question) || questionName.equals(question.getNameForForm()) || parentForm.isQuestionNameUnique(questionName)) {
            FormQuestionType type = question.getType();
            type.validateQuestionValues(values, errors);
            if (!errors.isEmpty()) {
                result.put("errors", errors);
                return result;
            }
            this._parametersManager.setParameterValues((ModifiableModelAwareDataHolder)question.getDataHolder(), type.getModel().getModelItems(), values);
            type.doAdditionalOperations(question, values);
            question.saveChanges();
            HashMap<String, Form> eventParams = new HashMap<String, Form>();
            eventParams.put("form", parentForm);
            this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
            result.put("id", question.getId());
            result.put("pageId", question.getParent().getId());
            result.put("formId", parentForm.getId());
            result.put("type", question.getType().toString());
        } else {
            errors.put("duplicate_name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_SET_ID_ERROR"));
            result.put("errors", errors);
            this.getLogger().error("An error occurred creating the question. The identifier value '" + questionName + "' is already used.");
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> deleteQuestion(String id) {
        FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        question.getForm().deleteQuestionsRule(question.getId());
        FormPage page = (FormPage)question.getParent();
        question.remove();
        page.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", page.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        return Map.of("id", id);
    }

    @Callable(rights={""})
    public Map<String, String> copyQuestion(String pageId, String questionId) {
        HashMap<String, String> result = new HashMap<String, String>();
        FormQuestion originalQuestion = (FormQuestion)this._resolver.resolveById(questionId);
        this._formDAO.checkHandleFormRight((AmetysObject)originalQuestion);
        FormPage parentPage = (FormPage)this._resolver.resolveById(pageId);
        Form parentForm = parentPage.getForm();
        String uniqueName = parentForm.findUniqueQuestionName(originalQuestion.getNameForForm());
        FormQuestion questionCopy = (FormQuestion)parentPage.createChild(uniqueName, "ametys:form-question");
        originalQuestion.copyTo((ModifiableDataHolder)questionCopy);
        String copyTitle = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGIN_FORMS_TREE_COPY_NAME_PREFIX")) + originalQuestion.getTitle();
        questionCopy.setTitle(parentForm.findUniqueQuestionTitle(copyTitle));
        questionCopy.setTypeId(originalQuestion.getType().getId());
        questionCopy.setNameForForm(uniqueName);
        for (String epId : this._copyFormEP.getExtensionsIds()) {
            CopyFormUpdater copyFormUpdater = (CopyFormUpdater)this._copyFormEP.getExtension(epId);
            copyFormUpdater.updateFormQuestion(originalQuestion, questionCopy);
        }
        parentPage.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", parentForm);
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", questionCopy.getId());
        result.put("pageId", parentPage.getId());
        result.put("formId", parentForm.getId());
        result.put("type", questionCopy.getType().getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> getRules(String id, int number) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        FormQuestionType type = question.getType();
        if (type instanceof ChoicesListQuestionType) {
            ChoicesListQuestionType cLType = (ChoicesListQuestionType)type;
            ChoiceSourceType sourceType = cLType.getSourceType(question);
            result.put("id", question.getId());
            result.put("number", String.valueOf(number));
            result.put("title", question.getTitle());
            ArrayList rules = new ArrayList();
            for (FormPageRule rule : question.getPageRules()) {
                String option = rule.getOption();
                HashMap<String, Object> enumParam = new HashMap<String, Object>();
                enumParam.put("question", (Object)question);
                I18nizableText label = sourceType.getEntry(new ChoiceOption(option), enumParam);
                HashMap<String, Object> resultRule = new HashMap<String, Object>();
                resultRule.put("option", option);
                resultRule.put("optionLabel", label);
                resultRule.put("type", (Object)rule.getType());
                String pageId = rule.getPageId();
                if (pageId != null) {
                    try {
                        FormPage page = (FormPage)this._resolver.resolveById(pageId);
                        resultRule.put("page", pageId);
                        resultRule.put("pageName", page.getTitle());
                    }
                    catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                        // empty catch block
                    }
                }
                rules.add(resultRule);
            }
            result.put("rules", rules);
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> addPageRule(String id, String option, String rule, String page) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        if (question.hasPageRule(option)) {
            result.put("error", "already-exists");
            return result;
        }
        question.addPageRules(option, FormPageRule.PageRuleType.valueOf(rule), page);
        question.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", question.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", question.getId());
        result.put("pageId", question.getFormPage().getId());
        result.put("formId", question.getForm().getId());
        result.put("type", question.getType().getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> deletePageRule(String id, String option) {
        FormQuestion question = (FormQuestion)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)question);
        question.deletePageRule(option);
        question.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", question.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    public List<FormQuestion> getRuleFilteredQuestions(Form form, FormEntryValues entryValues, Optional<Long> currentStepId, boolean onlyWritableQuestion, boolean onlyReadableQuestion) {
        ArrayList<FormQuestion> filteredQuestions = new ArrayList<FormQuestion>();
        for (FormQuestion activeQuestion : this._getActiveQuestions(form, entryValues, currentStepId, onlyWritableQuestion, onlyReadableQuestion)) {
            if (activeQuestion.getType().onlyForDisplay(activeQuestion)) continue;
            Optional<Rule> firstQuestionRule = activeQuestion.getFirstQuestionRule();
            if (firstQuestionRule.isPresent()) {
                Rule rule = firstQuestionRule.get();
                FormQuestion sourceQuestion = (FormQuestion)this._resolver.resolveById(rule.getSourceId());
                List<String> ruleValues = this._getRuleValues(entryValues, sourceQuestion.getNameForForm());
                boolean equalsRuleOption = ruleValues.contains(rule.getOption());
                Rule.QuestionRuleType ruleAction = rule.getAction();
                if ((equalsRuleOption || !ruleAction.equals((Object)Rule.QuestionRuleType.HIDE)) && (!equalsRuleOption || !ruleAction.equals((Object)Rule.QuestionRuleType.SHOW))) continue;
                filteredQuestions.add(activeQuestion);
                continue;
            }
            filteredQuestions.add(activeQuestion);
        }
        return filteredQuestions;
    }

    protected List<FormQuestion> _getActiveQuestions(Form form, FormEntryValues entryValues, Optional<Long> currentStepId, boolean onlyWritableQuestion, boolean onlyReadableQuestion) {
        String nextActivePage = null;
        ArrayList<FormQuestion> activeQuestions = new ArrayList<FormQuestion>();
        for (FormPage page : form.getPages()) {
            FormPageRule rule;
            if (nextActivePage == null || page.getId().equals(nextActivePage)) {
                nextActivePage = null;
                for (FormQuestion question : page.getQuestions()) {
                    ChoicesListQuestionType type;
                    FormQuestionType formQuestionType;
                    if (currentStepId.isEmpty() || (!onlyReadableQuestion || question.canRead(currentStepId.get())) && (!onlyWritableQuestion || question.canWrite(currentStepId.get()))) {
                        activeQuestions.add(question);
                    }
                    if (!((formQuestionType = question.getType()) instanceof ChoicesListQuestionType) || (type = (ChoicesListQuestionType)formQuestionType).getSourceType(question).remoteData()) continue;
                    List<String> ruleValues = this._getRuleValues(entryValues, question.getNameForForm());
                    for (FormPageRule rule2 : question.getPageRules()) {
                        if (!ruleValues.contains(rule2.getOption())) continue;
                        nextActivePage = this._getNextActivePage(rule2);
                    }
                }
            }
            if ((rule = page.getRule()) == null || nextActivePage != null) continue;
            nextActivePage = this._getNextActivePage(rule);
        }
        return activeQuestions;
    }

    private String _getNextActivePage(FormPageRule rule) {
        return rule.getType() == FormPageRule.PageRuleType.FINISH ? "finish" : rule.getPageId();
    }

    private List<String> _getRuleValues(FormEntryValues entryValues, String nameForForm) {
        Object ruleValue = entryValues.getValue(nameForForm);
        if (ruleValue == null) {
            return ListUtils.EMPTY_LIST;
        }
        if (ruleValue.getClass().isArray()) {
            String[] stringArray = ArrayUtils.toStringArray((Object[])((Object[])ruleValue));
            return Arrays.asList(stringArray);
        }
        return List.of(ruleValue.toString());
    }

    public boolean canSubmitterEditSubmission(FormQuestion question) {
        FormQuestionType type = question.getType();
        return !(type instanceof ComputedQuestionType) && !(type instanceof RichTextQuestionType);
    }

    public record FormEntryValues(Map<String, Object> inputValues, FormEntry entry) {
        Object getValue(String attributeName) {
            if (this.inputValues != null) {
                return this.inputValues.get(attributeName);
            }
            return this.entry.getValue(attributeName);
        }
    }
}

