/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.data.Answer;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.workflow.AbstractFormDashboardGenerator;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class FormDashboardGenerator
extends AbstractFormDashboardGenerator {
    protected WorkflowProvider _workflowProvider;
    protected FormDAO _formDAO;
    protected FormEntryDAO _formEntryDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._formDAO = (FormDAO)((Object)smanager.lookup(FormDAO.ROLE));
        this._formEntryDAO = (FormEntryDAO)((Object)smanager.lookup(FormEntryDAO.ROLE));
    }

    @Override
    protected List<Answer> _getAnswers(Request request, String siteName, String lang, UserIdentity user) throws FormsException {
        UserExpression userExpression = new UserExpression("ametys-user", Expression.Operator.EQ, user);
        List<Answer> collect = this._formDAO.getForms(siteName).stream().map(f -> this._formEntryDAO.getFormEntries((Form)((Object)f), false, (Expression)userExpression, List.of())).flatMap(Collection::stream).map(this::_formEntry2Answer).collect(Collectors.toList());
        return collect;
    }

    protected Answer _formEntry2Answer(FormEntry entry) {
        Form form = entry.getForm();
        String workflowName = form.getWorkflowName();
        return new Answer(entry.getId(), entry.getEntryId(), form.getId(), form.getTitle(), DateUtils.asDate((ZonedDateTime)entry.getSubmitDate()), form.getWorkflowName(), StringUtils.isNotBlank((CharSequence)workflowName) ? (int)entry.getWorkflowId() : -1, entry.getUser());
    }

    @Override
    protected Workflow _getWorkflow(Answer answer) {
        FormEntry formAnswer = (FormEntry)this._resolver.resolveById(answer.getId());
        return this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)formAnswer);
    }

    @Override
    protected void _saxWorkflowInformations(Answer answer, UserIdentity user) throws Exception {
        super._saxWorkflowInformations(answer, user);
        String workflowName = answer.getWorkflowName();
        if (StringUtils.isNotBlank((CharSequence)workflowName)) {
            int[] availableActions;
            FormEntry formEntry = (FormEntry)this._resolver.resolveById(answer.getId());
            Workflow workflow = this._getWorkflow(answer);
            WorkflowDescriptor workflowDescriptor = this._workflowHelper.getWorkflowDescriptor(answer.getWorkflowName());
            HashMap<String, FormEntry> inputs = new HashMap<String, FormEntry>();
            inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, formEntry);
            for (int actionId : availableActions = workflow.getAvailableActions((long)answer.getWorkflowId().intValue(), inputs)) {
                ActionDescriptor action = workflowDescriptor.getAction(actionId);
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("id", String.valueOf(actionId));
                Map metaAttributes = action.getMetaAttributes();
                String actionStatus = metaAttributes.getOrDefault("status", String.valueOf(actionId));
                attrs.addCDATAAttribute("status", actionStatus);
                this._saxActionType(action, attrs);
                I18nizableText workflowActionLabel = new I18nizableText("application", action.getName());
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"action", (Attributes)attrs);
                workflowActionLabel.toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"action");
            }
        }
    }

    private void _saxActionType(ActionDescriptor action, AttributesImpl attrs) {
        Map metaAttributes = action.getMetaAttributes();
        String actionType = (String)metaAttributes.get("action-type");
        if (actionType != null) {
            attrs.addCDATAAttribute("type", actionType);
        }
    }
}

