/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.List;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.helper.FormWorkflowHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormAdminDashboardHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormAdminDashboardHelper.class.getName();
    protected WorkflowProvider _workflowProvider;
    protected FormDAO _formDAO;
    protected RightManager _rightManager;
    protected FormEntryDAO _formEntryDAO;
    protected WorkflowHelper _workflowHelper;
    protected FormWorkflowHelper _formWorkflowHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
        this._formWorkflowHelper = (FormWorkflowHelper)((Object)manager.lookup(FormWorkflowHelper.ROLE));
    }

    public List<Form> getFormToAdmin(String siteName, UserIdentity currentUser) {
        return this._formDAO.getForms(siteName).stream().filter(Form::hasWorkflow).filter(f -> this._formEntryDAO.hasHandleDataRightOnForm(currentUser, (AmetysObject)f)).filter(f -> this._hasAtLeastOneEntryToDoAction((Form)((Object)f), currentUser)).toList();
    }

    protected boolean _hasAtLeastOneEntryToDoAction(Form form, UserIdentity user) {
        return form.getEntries().stream().filter(entry -> !entry.hasValue("anonymizationDate")).anyMatch(this::hasAvailableActions);
    }

    public boolean hasAvailableActions(FormEntry entry) {
        return this._formWorkflowHelper.getAvailableActionsExcludingTypes(entry, List.of("edit-by-submitter")).size() > 0;
    }
}

