/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FormWorkflowHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormWorkflowHelper.class.getName();
    public static final String EDIT_ACTION = "edit";
    public static final String EDIT_BY_SUBMITTER_ACTION = "edit-by-submitter";
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
    }

    public void initializeWorkflow(FormEntry entry) throws Exception {
        Form form = entry.getForm();
        String workflowName = form.getWorkflowName();
        if (StringUtils.isNotBlank((CharSequence)workflowName)) {
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
            int initialActionId = this._workflowHelper.getInitialAction(workflowName);
            HashMap<String, FormEntry> inputs = new HashMap<String, FormEntry>();
            inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, entry);
            long workflowInstanceId = workflow.initialize(workflowName, initialActionId, inputs);
            entry.setWorkflowId(workflowInstanceId);
        }
    }

    public List<ActionDescriptor> getAvailableActionsRestrictedToTypes(FormEntry entry, List<String> types) {
        Predicate<String> includeTest = actionType -> types.isEmpty() || types.contains(actionType);
        return this.getAvailableActions(entry, includeTest);
    }

    public List<ActionDescriptor> getAvailableActionsExcludingTypes(FormEntry entry, List<String> excludedTypes) {
        Predicate<String> includeTest = actionType -> excludedTypes.isEmpty() || !excludedTypes.contains(actionType);
        return this.getAvailableActions(entry, includeTest);
    }

    protected List<ActionDescriptor> getAvailableActions(FormEntry entry, Predicate<String> actionTypeFilter) {
        ArrayList<ActionDescriptor> availableActions = new ArrayList<ActionDescriptor>();
        HashMap<String, FormEntry> inputs = new HashMap<String, FormEntry>();
        inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, entry);
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
        int[] actions = workflow.getAvailableActions(entry.getWorkflowId(), inputs);
        WorkflowDescriptor workflowDescriptor = this._workflowHelper.getWorkflowDescriptor(entry.getForm().getWorkflowName());
        for (int actionId : actions) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId);
            Map metaAttributes = action.getMetaAttributes();
            String actionType = metaAttributes.getOrDefault("action-type", "");
            if (actionTypeFilter != null && !actionTypeFilter.test(actionType)) continue;
            availableActions.add(action);
        }
        return availableActions;
    }
}

