/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.search.UserAndGroupSearchManager;
import org.ametys.plugins.forms.question.sources.AbstractSourceType;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UsersSourceType
extends AbstractSourceType {
    public static final String ATTRIBUTE_POPULATION_ID = "population-id";
    protected Map<String, ModelItem> _usersSourceItems;
    protected UserManager _userManager;
    protected UserAndGroupSearchManager _userAndGroupSearchManager;
    protected RightManager _rightManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userAndGroupSearchManager = (UserAndGroupSearchManager)manager.lookup(UserAndGroupSearchManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    @Override
    public Map<String, ModelItem> getModelItems() {
        this._usersSourceItems = new HashMap<String, ModelItem>();
        ElementDefinition population = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_POPULATION_ID, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_USERS_POPULATION", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_USERS_POPULATION_DESC", (Validator)new DefaultValidator(null, true));
        population.setWidget("edition.userpopulation");
        this._usersSourceItems.put(population.getName(), (ModelItem)population);
        return this._usersSourceItems;
    }

    @Override
    public List<ViewItem> getViewItems() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        ViewElement grid = new ViewElement();
        grid.setDefinition((ElementDefinition)this._usersSourceItems.get(ATTRIBUTE_POPULATION_ID));
        viewElements.add((ViewItem)grid);
        return viewElements;
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished() {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished();
        fieldNames.add(ATTRIBUTE_POPULATION_ID);
        return fieldNames;
    }

    @Override
    public boolean remoteData() {
        return true;
    }

    @Override
    public I18nizableText getEntry(ChoiceOption value, Map<String, Object> contextParams) throws Exception {
        UserIdentity id = (UserIdentity)value.getValue();
        User user = this._userManager.getUser(id);
        if (user != null) {
            return new I18nizableText(user.getSortableName());
        }
        return null;
    }

    @Override
    public Map<ChoiceOption, I18nizableText> getTypedEntries(Map<String, Object> contextParams) throws Exception {
        throw new UnsupportedOperationException("Method getTypedEntries can't be called for UsersSourceType");
    }

    @Override
    public Map<ChoiceOption, I18nizableText> searchEntries(Map<String, Object> contextParams, int limit, Object paginationData) throws Exception {
        LinkedHashMap<ChoiceOption, I18nizableText> entries = new LinkedHashMap<ChoiceOption, I18nizableText>();
        FormQuestion question = this._getQuestionFromParam(contextParams);
        String populationId = (String)question.getValue(ATTRIBUTE_POPULATION_ID);
        HashMap<String, Map<String, Integer>> paginationParam = new HashMap<String, Map<String, Integer>>();
        int offset = paginationData != null ? ((Integer)paginationData - 1) * limit : 0;
        paginationParam.put("users", Map.of(populationId, offset));
        Map search = this._userAndGroupSearchManager.searchUsersAndGroup(Set.of(populationId), Set.of(), limit, paginationParam, contextParams, true);
        List results = (List)search.get("results");
        for (Map member : results) {
            String id = String.valueOf(member.get("login")) + "#" + String.valueOf(member.get("populationId"));
            String label = (String)member.get("sortablename");
            ChoiceOption choice = new ChoiceOption(id);
            entries.put(choice, new I18nizableText(label));
        }
        return entries;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "user";
    }

    @Override
    public String getJSRenderer() {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.renderUserChoiceList";
    }

    @Override
    public Object removeEmptyOrOtherValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ArrayList<UserIdentity> newVal = new ArrayList<UserIdentity>();
            for (UserIdentity val : (UserIdentity[])value) {
                if (val == null) continue;
                newVal.add(val);
            }
            if (newVal.isEmpty()) {
                return null;
            }
            return newVal.toArray(new UserIdentity[newVal.size()]);
        }
        return value;
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        return this._getComputedComplexValue(value, question, entry);
    }

    @Override
    public String value2String(Object value) {
        if (value instanceof UserIdentity) {
            UserIdentity user = (UserIdentity)value;
            return UserIdentity.userIdentityToString((UserIdentity)user);
        }
        return super.value2String(value);
    }

    @Override
    public Object getAnonimizedValue(FormQuestion question) {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY;
    }

    @Override
    public boolean hasRight(UserIdentity user, Form form) {
        boolean hasRight = super.hasRight(user, form);
        return hasRight && this._rightManager.hasRight(user, "Runtime_Rights_ListUsers", (Object)form) == RightManager.RightResult.RIGHT_ALLOW;
    }
}

