/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.validators.NumberIntervalFormValidator;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.Validator;

public class NumberQuestionType
extends AbstractFormQuestionType {
    public static final String ATTRIBUTE_MIN_DOUBLE = "min-double";
    public static final String ATTRIBUTE_MAX_DOUBLE = "max-double";
    public static final String ATTRIBUTE_MIN_INT = "min-int";
    public static final String ATTRIBUTE_MAX_INT = "max-int";
    public static final String ATTRIBUTE_NUMBER_TYPE = "number-type";
    public static final String DOUBLE_NUMBER_VALUE = "double";
    public static final String INTEGER_NUMBER_VALUE = "int";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_NUMBER";

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        ViewElement numberType = new ViewElement();
        numberType.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_NUMBER_TYPE));
        advancedFieldset.addViewItem((ViewItem)numberType);
        ViewElement min = new ViewElement();
        min.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MIN_DOUBLE));
        advancedFieldset.addViewItem((ViewItem)min);
        ViewElement max = new ViewElement();
        max.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MAX_DOUBLE));
        advancedFieldset.addViewItem((ViewItem)max);
        ViewElement minInt = new ViewElement();
        minInt.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MIN_INT));
        advancedFieldset.addViewItem((ViewItem)minInt);
        ViewElement maxInt = new ViewElement();
        maxInt.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MAX_INT));
        advancedFieldset.addViewItem((ViewItem)maxInt);
        return advancedFieldset;
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        DataHolderRelativeDisableConditions doubleDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition conditionDouble = new DataHolderRelativeDisableCondition(ATTRIBUTE_NUMBER_TYPE, DisableCondition.OPERATOR.NEQ, DOUBLE_NUMBER_VALUE, this._disableConditionsHelper);
        doubleDisableConditions.getConditions().add(conditionDouble);
        ElementDefinition minDouble = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MIN_DOUBLE, DOUBLE_NUMBER_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MIN", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MIN_DESC", null);
        minDouble.setDisableConditions((DisableConditions)doubleDisableConditions);
        modelItems.add((ModelItem)minDouble);
        ElementDefinition maxDouble = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MAX_DOUBLE, DOUBLE_NUMBER_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MAX", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MAX_DESC", null);
        maxDouble.setDisableConditions((DisableConditions)doubleDisableConditions);
        modelItems.add((ModelItem)maxDouble);
        DataHolderRelativeDisableConditions integerDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition conditionInteger = new DataHolderRelativeDisableCondition(ATTRIBUTE_NUMBER_TYPE, DisableCondition.OPERATOR.NEQ, INTEGER_NUMBER_VALUE, this._disableConditionsHelper);
        integerDisableConditions.getConditions().add(conditionInteger);
        ElementDefinition minInt = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MIN_INT, "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MIN", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MIN_DESC", null);
        minInt.setDisableConditions((DisableConditions)integerDisableConditions);
        modelItems.add((ModelItem)minInt);
        ElementDefinition maxInt = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MAX_INT, "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MAX", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_MAX_DESC", null);
        maxInt.setDisableConditions((DisableConditions)integerDisableConditions);
        modelItems.add((ModelItem)maxInt);
        ElementDefinition numberType = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_NUMBER_TYPE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_NUMBER_TYPE", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_NUMBER_TYPE_DESC", null);
        StaticEnumerator numberTypeStaticEnumerator = new StaticEnumerator();
        numberTypeStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_TYPE_DOUBLE"), (Object)DOUBLE_NUMBER_VALUE);
        numberTypeStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_TYPE_INT"), (Object)INTEGER_NUMBER_VALUE);
        numberType.setEnumerator((Enumerator)numberTypeStaticEnumerator);
        numberType.setDefaultValue((Object)INTEGER_NUMBER_VALUE);
        modelItems.add((ModelItem)numberType);
        return modelItems;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        String type = (String)question.getValue(ATTRIBUTE_NUMBER_TYPE);
        return type.equals(DOUBLE_NUMBER_VALUE) ? DOUBLE_NUMBER_VALUE : "long";
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        if (DOUBLE_NUMBER_VALUE.equals(question.getValue(ATTRIBUTE_NUMBER_TYPE))) {
            ((ElementDefinition)item).setValidator((Validator)new NumberIntervalFormValidator(null, this.isMandatory(question), (Number)question.getValue(ATTRIBUTE_MIN_DOUBLE), (Number)question.getValue(ATTRIBUTE_MAX_DOUBLE)));
        } else {
            ((ElementDefinition)item).setValidator((Validator)new NumberIntervalFormValidator(null, this.isMandatory(question), (Number)question.getValue(ATTRIBUTE_MIN_INT), (Number)question.getValue(ATTRIBUTE_MAX_INT)));
        }
        return item;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        String format;
        super.validateQuestionValues(values, errors);
        switch (format = (String)values.get(ATTRIBUTE_NUMBER_TYPE)) {
            case "double": {
                Number minDouble = values.getOrDefault(ATTRIBUTE_MIN_DOUBLE, null);
                Number maxDouble = values.getOrDefault(ATTRIBUTE_MAX_DOUBLE, null);
                if (minDouble == null || maxDouble == null || !(minDouble.doubleValue() > maxDouble.doubleValue())) break;
                errors.put(ATTRIBUTE_MIN_DOUBLE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_GAP_ERROR"));
                errors.put(ATTRIBUTE_MAX_DOUBLE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_GAP_ERROR"));
                break;
            }
            case "int": {
                Number min = values.getOrDefault(ATTRIBUTE_MIN_INT, null);
                Number max = values.getOrDefault(ATTRIBUTE_MAX_INT, null);
                if (min == null || max == null || min.longValue() <= max.longValue()) break;
                errors.put(ATTRIBUTE_MIN_INT, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_GAP_ERROR"));
                errors.put(ATTRIBUTE_MAX_INT, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_NUMBER_GAP_ERROR"));
                break;
            }
            default: {
                this.getLogger().error("Number format " + format + " is not supported");
            }
        }
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_NUMBER_TYPE);
        return fieldNames;
    }

    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        return Collections.singletonMap(question.getNameForForm(), this.isMandatory(question) ? Long.valueOf(0L) : null);
    }
}

