/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.Closeable;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.workflow.WorkflowFormMail;
import org.ametys.plugins.forms.workflow.WorkflowFormMailExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class FormSendMailFunction
extends AbstractLogEnabled
implements Component,
EnhancedFunction,
Serviceable {
    public static final String ARG_SENDER = "sender";
    public static final String ARG_SENDER_ROLE = "sender-role";
    public static final String ARG_RECIPIENT = "recipient";
    public static final String ARG_RECIPIENT_ROLE = "recipient-role";
    public static final String ARG_SUBJECT_KEY = "subject-key";
    public static final String ARG_BODY_KEY = "body-key";
    public static final String ARG_BODY_XSL = "body-xsl";
    public static final String ARG_COMMENT = "comment";
    public static final String ARG_SEND_IF_COMMENT = "send-if-comment";
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected SourceResolver _sourceResolver;
    protected AmetysObjectResolver _resolver;
    protected FormDAO _formDAO;
    protected I18nUtils _i18nUtils;
    protected WorkflowFormMailExtensionPoint _workflowFormMailEP;
    protected SiteManager _siteManager;
    protected FormMailHelper _formMailHelper;
    protected UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._workflowFormMailEP = (WorkflowFormMailExtensionPoint)((Object)manager.lookup(WorkflowFormMailExtensionPoint.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._formMailHelper = (FormMailHelper)((Object)manager.lookup(FormMailHelper.ROLE));
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String sendIfComment = this._getStringParam(args, ARG_SEND_IF_COMMENT);
        String comment = this._getStringParam(transientVars, ARG_COMMENT);
        if (!StringUtils.equals((CharSequence)sendIfComment, (CharSequence)"true") || StringUtils.isNotBlank((CharSequence)comment)) {
            FormEntry formEntry = (FormEntry)((Object)transientVars.get(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY));
            String sender = this._getSender(formEntry, transientVars, args);
            List<UserAndMail> recipients = this._getRecipients(formEntry, transientVars, args);
            ArrayList records = this._addAttachment() ? this._formMailHelper.getEntryFiles(formEntry.getForm(), formEntry, this._onlyWritableQuestionForAttachment(), this._onlyReadableQuestionForAttachment()) : new ArrayList();
            try {
                I18nizableText subject = this._getSubject(formEntry, transientVars, args);
                try {
                    for (UserAndMail recipient : recipients) {
                        String language = null;
                        User user = recipient.user();
                        if (user != null) {
                            language = user.getLanguage();
                        }
                        language = (String)StringUtils.defaultIfBlank((CharSequence)language, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)this._formDAO.getFormLocale(formEntry.getForm()), (CharSequence)this._userLanguagesManager.getDefaultLanguage())));
                        String subjectAsString = this._i18nUtils.translate((I18nizable)subject, language);
                        String body = this._getBody(formEntry, transientVars, args, recipient, subject, language);
                        try {
                            SendMailHelper.MailBuilder mailBuilder = SendMailHelper.newMail().withAsync(true).withSubject(subjectAsString).withHTMLBody(body).withSender(sender).withRecipient(recipient.mail());
                            if (!records.isEmpty()) {
                                mailBuilder = mailBuilder.withAttachmentsAsStream(records);
                            }
                            mailBuilder.sendMail();
                        }
                        catch (MessagingException | IOException e) {
                            this.getLogger().warn("Could not send a workflow notification mail to " + String.valueOf(recipient), e);
                        }
                    }
                }
                finally {
                    for (SendMailHelper.NamedStream record : records) {
                        IOUtils.close((Closeable)record.inputStream());
                    }
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Could not send a workflow notification mail", (Throwable)e);
            }
        }
    }

    protected boolean _addAttachment() {
        return false;
    }

    protected boolean _onlyWritableQuestionForAttachment() {
        return false;
    }

    protected boolean _onlyReadableQuestionForAttachment() {
        return false;
    }

    protected String _getSender(FormEntry formEntry, Map transientVars, Map args) {
        String email;
        WorkflowFormMail workflowMail;
        List<String> emails;
        String role = this._getStringParam(args, ARG_SENDER_ROLE);
        if (StringUtils.isNotBlank((CharSequence)role) && (emails = (workflowMail = (WorkflowFormMail)this._workflowFormMailEP.getExtension(role)).getEmails(formEntry, transientVars, args)) != null && !emails.isEmpty()) {
            return emails.get(0);
        }
        String sender = this._getStringParam(args, ARG_SENDER);
        if (StringUtils.isNotBlank((CharSequence)sender)) {
            return sender;
        }
        User user = this._userManager.getUser(this._currentUserProvider.getUser());
        String string = email = user != null ? user.getEmail() : null;
        if (StringUtils.isNotBlank((CharSequence)email)) {
            return email;
        }
        return (String)Config.getInstance().getValue("smtp.mail.from");
    }

    protected List<UserAndMail> _getRecipients(FormEntry formEntry, Map transientVars, Map args) {
        WorkflowFormMail workflowMail;
        List<String> emails;
        String role = this._getStringParam(args, ARG_RECIPIENT_ROLE);
        if (StringUtils.isNotBlank((CharSequence)role) && (emails = (workflowMail = (WorkflowFormMail)this._workflowFormMailEP.getExtension(role)).getEmails(formEntry, transientVars, args)) != null && !emails.isEmpty()) {
            return emails.stream().map(mail -> new UserAndMail(null, (String)mail)).toList();
        }
        String recipient = this._getStringParam(args, ARG_RECIPIENT);
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            return List.of(new UserAndMail(null, recipient));
        }
        User user = this._userManager.getUser(formEntry.getUser());
        return user != null ? List.of(new UserAndMail(user, user.getEmail())) : List.of();
    }

    protected I18nizableText _getSubject(FormEntry formEntry, Map transientVars, Map args) {
        String subjectI18nKey = this._getStringParam(args, ARG_SUBJECT_KEY);
        if (StringUtils.isNotBlank((CharSequence)subjectI18nKey)) {
            return new I18nizableText(null, subjectI18nKey, this._getSubjectI18nParams(formEntry));
        }
        return new I18nizableText(null, "", this._getSubjectI18nParams(formEntry));
    }

    protected String _getBody(FormEntry formEntry, Map transientVars, Map args, UserAndMail receiver, I18nizableText subject, String language) throws IOException {
        String xslPath = this._getStringParam(args, ARG_BODY_XSL);
        if (StringUtils.isNotBlank((CharSequence)xslPath)) {
            User user;
            String comment = this._getStringParam(transientVars, ARG_COMMENT);
            HashMap<String, Object> additionalParams = new HashMap<String, Object>();
            additionalParams.put("xsl", xslPath);
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                additionalParams.put(ARG_COMMENT, comment);
            }
            boolean withReadingRestriction = (user = receiver.user()) != null ? Objects.equals(user.getIdentity(), formEntry.getUser()) : false;
            String body = this._formMailHelper.getMail("send-mail-function.html", formEntry, additionalParams, withReadingRestriction);
            return StandardMailBodyHelper.newHTMLBody().withLanguage(language).withTitle(subject).withMessage(body).build();
        }
        return this._getBodyFromI18nKey(formEntry, transientVars, args, subject, language);
    }

    protected String _getBodyFromI18nKey(FormEntry formEntry, Map transientVars, Map args, I18nizableText subject, String language) throws IOException {
        String comment = this._getStringParam(transientVars, ARG_COMMENT);
        String bodyI18nKey = this._getStringParam(args, ARG_BODY_KEY);
        I18nizableText bodyKey = StringUtils.isNotBlank((CharSequence)bodyI18nKey) ? new I18nizableText(null, bodyI18nKey, this._getBodyI18nParams(formEntry)) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_SEND_MAIL_FUNCTION_DEFAULT_BODY", this._getBodyI18nParams(formEntry));
        StandardMailBodyHelper.MailBodyBuilder mailBody = StandardMailBodyHelper.newHTMLBody().withLanguage(language).withTitle(subject).withMessage(bodyKey);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(comment);
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            mailBody.withUserInputs(List.of(new StandardMailBodyHelper.MailBodyBuilder.UserInput(this._userManager.getUser(userIdentity), ZonedDateTime.now(), (Object)comment.replaceAll("\r?\n", "<br/>"))));
        }
        return mailBody.build();
    }

    protected List<String> _getSubjectI18nParams(FormEntry formEntry) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(formEntry.getForm().getTitle());
        User user = this._userManager.getUser(formEntry.getUser());
        if (user != null) {
            params.add(user.getFullName());
        }
        return params;
    }

    protected List<String> _getBodyI18nParams(FormEntry formEntry) {
        Form form = formEntry.getForm();
        String siteName = form.getSiteName();
        UserIdentity userIdentity = formEntry.getUser();
        User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        ArrayList<String> params = new ArrayList<String>();
        params.add(user != null ? user.getFullName() : "");
        params.add(form.getTitle());
        params.add(this._formDAO.getDashboardUri(siteName));
        params.add(this._formDAO.getAdminDashboardUri(siteName));
        return params;
    }

    private String _getStringParam(Map args, String key) {
        Object object = args.get(key);
        return object != null ? (String)object : null;
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.POST;
    }

    public List<WorkflowArgument> getArguments() {
        WorkflowArgument senderRole = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SENDER_ROLE, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SENDER_ROLE_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SENDER_ROLE_DESCRIPTION"), (boolean)false, (boolean)false);
        StaticEnumerator roleStaticEnumerator = new StaticEnumerator();
        for (String epId : this._workflowFormMailEP.getExtensionsIds()) {
            roleStaticEnumerator.add(new I18nizableText(epId), (Object)epId);
        }
        senderRole.setEnumerator((Enumerator)roleStaticEnumerator);
        WorkflowArgument recipientRole = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_RECIPIENT_ROLE, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_ROLE_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_ROLE_DESCRIPTION"), (boolean)false, (boolean)false);
        recipientRole.setEnumerator((Enumerator)roleStaticEnumerator);
        StaticEnumerator booleanStaticEnumerator = new StaticEnumerator();
        booleanStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_TRUE_LABEL"), (Object)"true");
        booleanStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_FALSE_LABEL"), (Object)"false");
        WorkflowArgument sendIfComment = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SEND_IF_COMMENT, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SEND_IF_COMMENT_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SEND_IF_COMMENT_DESCRIPTION"), (boolean)false, (boolean)false);
        sendIfComment.setEnumerator((Enumerator)booleanStaticEnumerator);
        return List.of(WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SENDER, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SENDER_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SENDER_DESCRIPTION"), (boolean)false, (boolean)false), senderRole, WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_RECIPIENT, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_DESCRIPTION"), (boolean)false, (boolean)true), recipientRole, WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SUBJECT_KEY, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SUBJECT_KEY_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_SUBJECT_KEY_DESCRIPTION"), (boolean)false, (boolean)false), WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_BODY_KEY, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_BODY_KEY_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_BODY_KEY_DESCRIPTION"), (boolean)false, (boolean)false), WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_BODY_XSL, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_BODY_XSL_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_BODY_XSL_DESCRIPTION"), (boolean)false, (boolean)false), WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_COMMENT, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_COMMENT_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_ARGUMENT_COMMENT_DESCRIPTION"), (boolean)false, (boolean)false), sendIfComment);
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_SEND_MAIL_FUNCTION_LABEL");
    }

    private record UserAndMail(User user, String mail) {
    }
}

