/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.workflow.AbstractMailInformationHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class MailInformationHelper
extends AbstractMailInformationHelper {
    public static final String ROLE = MailInformationHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected FormMailHelper _formMailHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._formMailHelper = (FormMailHelper)((Object)serviceManager.lookup(FormMailHelper.ROLE));
    }

    @Override
    protected List<AbstractMailInformationHelper.MailInfo> _getMailInfos(String formId, Object entryId) {
        String email;
        User user;
        ArrayList<AbstractMailInformationHelper.MailInfo> emails = new ArrayList<AbstractMailInformationHelper.MailInfo>();
        FormEntry formEntry = (FormEntry)this._resolver.resolveById((String)entryId);
        UserIdentity userId = formEntry.getUser();
        if (userId != null && (user = this._userManager.getUser(userId)) != null && StringUtils.isNotBlank((CharSequence)(email = user.getEmail()))) {
            AbstractMailInformationHelper.MailInfo mailInfo = new AbstractMailInformationHelper.MailInfo(email, user.getFullName() + " <" + email + ">");
            emails.add(mailInfo);
        }
        for (FormQuestion question : this._formMailHelper.getQuestionWithMail(formId)) {
            Optional<String> receiver = this._formMailHelper.getReceiver(formEntry, Optional.of(question.getNameForForm()));
            if (!receiver.isPresent()) continue;
            AbstractMailInformationHelper.MailInfo mailInfo = new AbstractMailInformationHelper.MailInfo(receiver.get(), question.getTitle() + " <" + receiver.get() + ">");
            emails.add(mailInfo);
        }
        return emails;
    }
}

