/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const NameHelper = Java.type('org.ametys.plugins.repository.jcr.NameHelper');

const I18nUtils = Java.type('org.ametys.core.util.I18nUtils');
const i18nUtilsComponent = Ametys.serviceManager.lookup(I18nUtils.ROLE);
  
const FormDAO = Java.type('org.ametys.plugins.forms.dao.FormDAO');
const FormDAOComponent = Ametys.serviceManager.lookup(FormDAO.ROLE);
  
const I18nizableText = Java.type("org.ametys.runtime.i18n.I18nizableText");
const List = Java.type("java.util.List");
const SimpleTextQuestionType = Java.type("org.ametys.plugins.forms.question.types.impl.SimpleTextQuestionType");
const CurrentUserAutoFillSource = Java.type("org.ametys.plugins.forms.question.autofill.CurrentUserAutoFillSource");

/** Migration autofill attributes in form question */
logger.info("Start migration of autofill attributes for default session");
updateAutofillFields(Repository.session);
  
/** Migration autofill attributes in form question */
logger.info("Start migration of autofill attributes for live session");
updateAutofillFields(Repository.liveSession);
  
function updateAutofillFields(session)
{
    let count = 0;
    Repository.query("//element(*, ametys:form-question)[@ametys:autofill != '']", true, session).forEach(function(question) {
      if (question.getValue(SimpleTextQuestionType.ATTRIBUTE_AUTOFILL_SOURCE) == null)
      {
        logger.info("Migrating autofill value of question '" + question.getId() + "'");
        let oldAutofillValue = question.getValue(CurrentUserAutoFillSource.ATTRIBUTE_AUTOFILL);
        let sourceId = getSourceId(oldAutofillValue);
        question.setValue(SimpleTextQuestionType.ATTRIBUTE_AUTOFILL_SOURCE, sourceId);
        if (sourceId == "org.ametys.plugins.forms.question.autofill.Custom" || sourceId == null)
        {
          	question.setValue(CurrentUserAutoFillSource.ATTRIBUTE_AUTOFILL, null);
        }
        
        count++;
      }
    });
 
    if (count > 0)
    {
        session.save(); 
    }
    logger.info(`${count} form questions node(s) have be updated in workspaces ${session.getWorkspace().getName()}`);
}  

function getSourceId(oldAutofillValue)
{
	switch (oldAutofillValue)
	{
		case "custom": 
			return "org.ametys.plugins.forms.question.autofill.Custom";
			
		case " " :
			return "";
		default:
			return "org.ametys.plugins.forms.question.autofill.Default";
	} 
}