/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
  
const ConnectionHelper = Java.type('org.ametys.core.datasource.ConnectionHelper');
const _formTableManager = Ametys.serviceManager.lookup(org.ametys.plugins.forms.content.table.FormTableManager.ROLE);
const _sqlEP = Ametys.serviceManager.lookup(org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint.ROLE);
  
let config = org.ametys.runtime.config.Config.getInstance();
let dataSourceId = config.getValue(org.ametys.plugins.forms.content.table.FormTableManager.FORMS_POOL_CONFIG_PARAM);
let connection = null;
  
try
{
    connection = org.ametys.core.datasource.ConnectionHelper.getConnection(dataSourceId);
    let dbType = org.ametys.core.datasource.ConnectionHelper.getDatabaseType(connection);
    let metadata = connection.getMetaData();
    
    for (let tableName of _formTableManager.getTableNames())
    {
        let loginColumnRSMaj = metadata.getColumns(null, null, tableName, "LOGIN");
        let loginColumnRSMin = metadata.getColumns(null, null, tableName, "login");
        if (loginColumnRSMaj.next() || loginColumnRSMin.next())
        {
            logger.info("Table name '" + tableName + "' has already a login column");
        }
        else
        {
            let normalizedTableName = _sqlEP.languageEscapeTableName(dbType, tableName);

            let varType = org.ametys.plugins.forms.content.table.DbTypeHelper.getVarcharType(dbType);
            update(connection, `ALTER TABLE ${normalizedTableName} ADD COLUMN login ${varType} DEFAULT NULL`);
            update(connection, `ALTER TABLE ${normalizedTableName} ADD COLUMN populationId ${varType} DEFAULT NULL`);
        }
    }
}
finally
{
    try 
    {
        if (!connection.getAutoCommit()) { connection.commit();}
    } 
    catch (e) { logger.error("Error while closing database", e); }
    
    try 
    {
        connection.close();
    } 
    catch (e) { logger.error("Error while closing database", e); }
    
}

function update(connection, updateQuery)
{
    let stmt = null;
    try
    {
        stmt = connection.prepareStatement(updateQuery);
        stmt.executeUpdate();
    }
    finally
    {
        try
        {
            if (stmt != null)
            {
                stmt.close();
            }
        }    
        catch (e) { logger.error("Error while closing stmt", e); }
    }
}

