/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define('Ametys.plugins.form.FormTargetToContextConvertor', {
    extend: 'Ametys.plugins.coreui.rights.AbstractTargetToContextConvertor',
    
    isSupportedTarget: function(target)
    {
        return target != null 
        && (target.getId() == Ametys.message.MessageTarget.FORM_DIRECTORY
        || target.getId() == Ametys.message.MessageTarget.FORM_TARGET);
    },
    
    convert: function(target)
    {
        return target.getParameters().id;
    },
    
    getContextInfo:function(target)
    {
        if (target.getId() == Ametys.message.MessageTarget.FORM_DIRECTORY)
        {
            // FIXME we should have a better way to determine that its the root
            if (target.getParameters().title == "ametys:forms")
            {
                return {label: "{{i18n PLUGINS_FORMS_FORMSDIRECTORYACCESS_CONTEXT_HINT_ROOT}}"};
            }
            return {label: target.getParameters().title, type: '{{i18n PLUGINS_FORM_TARGET_CONVERTOR_FORM_DIRECTORY_TYPE_LABEL}}'};
        }
        else
        {
            return {label: target.getParameters().title, type: '{{i18n PLUGINS_FORM_TARGET_CONVERTOR_FORM_TYPE_LABEL}}'};
        }
    }
});

