/**
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This schedule opening form button controller
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.ScheduleOpeningController', {
	extend: 'Ametys.plugins.forms.controllers.FormController',
	
	_updateToggleState: function(params)
    {
		var scheduleStatus = params.scheduleStatus;

        var description = "";
        var iconDecorator = null;
        if ('OPEN' == scheduleStatus)
        {
            description = "{{i18n PLUGINS_FORMS_OPENING_SCHEDULE_DESCRIPTION_OPEN}}";
            iconDecorator = "decorator-ametysicon-check34";
        }
        else if ('COMING' == scheduleStatus)
        {
            description = "{{i18n PLUGINS_FORMS_OPENING_SCHEDULE_DESCRIPTION_FORTHCOMING}}";
            iconDecorator = "decorator-ametysicon-clock56";
        }
        else if ('OVER' == scheduleStatus)
        {
            description = "{{i18n PLUGINS_FORMS_OPENING_SCHEDULE_DESCRIPTION_OUTOFDATE}}";
            iconDecorator = "decorator-ametysicon-stop5";
        }
        
		this.setAdditionalDescription(description);
        this.setIconDecorator(iconDecorator);
        this.toggle(scheduleStatus != null);
	}
});
