--
--  Copyright 2021 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--

DROP TABLE IF EXISTS Form_Session;
CREATE TABLE Form_Session (
    sessionId INTEGER AUTO_INCREMENT NOT NULL,
    formId varchar(64),
    login varchar(64) BINARY,
    population varchar(200) BINARY,
    IPAddress varchar(32),
    submittedAt datetime,
    PRIMARY KEY(sessionId)
);

DROP TABLE IF EXISTS Form_Answer;
CREATE TABLE Form_Answer (
    sessionId INTEGER,
    questionId varchar(64),
    answer TEXT,
    PRIMARY KEY(sessionId, questionId)
);
