/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.processing;

import java.io.IOException;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;

/**
 * Generates the results.
 */
public class FormResultsGenerator extends AbstractFormFieldGenerator
{
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> params = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        
        Form form = (Form) params.get("form");
        @SuppressWarnings("unchecked")
        Map<String, FieldValue> input = (Map<String, FieldValue>) params.get("input");
        
        contentHandler.startDocument();
        
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", form.getId());
        atts.addCDATAAttribute("label", URIUtils.decode(form.getLabel()));
        
        XMLUtils.startElement(contentHandler, "form-results", atts);
        
        for (FieldValue entry : input.values())
        {
            saxFieldValue("entry", entry);
        }
        
        XMLUtils.endElement(contentHandler, "form-results");
        contentHandler.endDocument();
    }
}
