/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.properties.section;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.properties.section.AbstractDefaultPropertySection;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;

/**
 * Section displaying submit informations of the form entry.
 */
public class FormEntrySubmitSection extends AbstractDefaultPropertySection implements Serviceable
{
    private UserHelper _userHelper;

    public void service(ServiceManager smanager) throws ServiceException
    {
        _userHelper = (UserHelper) smanager.lookup(UserHelper.ROLE);
    }
    
    public boolean supports(AmetysObject ametysObject)
    {
        return ametysObject instanceof FormEntry;
    }
    
    @Override
    protected Map<String, Object> buildData(AmetysObject ametysObject)
    {
        Map<String, Object> resultMap = new LinkedHashMap<>();
        
        FormEntry formEntry = (FormEntry) ametysObject;
        resultMap.put("id", formEntry.getEntryId());
        
        Map<String, Object> data = new HashMap<>();
        data.put("date", DateUtils.zonedDateTimeToString(formEntry.getSubmitDate()));
        data.put("user", _userHelper.user2json(formEntry.getUser(), true));
        resultMap.put("submit", data);
        
        return resultMap;
    }
}
