/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.properties.section.technical;

import java.util.LinkedHashMap;
import java.util.Map;

import org.ametys.cms.properties.section.technical.impl.AmetysObjectIdItem;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;

/**
 * Section displaying values of the attaching form of the form entry.
 */
public class FormEntryFormItem extends AmetysObjectIdItem
{
    @Override
    public boolean supports(AmetysObject ametysObject)
    {
        return ametysObject instanceof FormEntry;
    }
    
    @Override
    public Map<String, Object> buildData(AmetysObject ametysObject)
    {
        Map<String, Object> resultMap = new LinkedHashMap<>();
        
        resultMap.put("title", ((Form) _getTargetedAO(ametysObject)).getTitle());
        resultMap.putAll(super.buildData(ametysObject));
        
        return resultMap;
    }
    
    @Override
    protected AmetysObject _getTargetedAO(AmetysObject ametysObject)
    {
        return ((FormEntry) ametysObject).getForm();
    }
}
