/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.autofill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.type.ModelItemTypeConstants;
import org.ametys.runtime.parameter.DefaultValidator;

/**
 * Class for adding custom value as default value in text  fields
 */
public class CustomValueAutoFillSource extends AbstractStaticAutoFillSource
{
    /** Constant for default value attribute. */
    public static final String ATTRIBUTE_DEFAULT_VALUE = "default-value";
    

    /** Map of ModelItems specific to CustomValueAutoFillSource */
    protected Map<String, ModelItem> _autoFillItems;
    
    public String getAutofillValue(FormQuestion question)
    {
        return question.getValue(ATTRIBUTE_DEFAULT_VALUE);
    }

    public Map<String, ModelItem> getModelItems()
    {
        _autoFillItems = new HashMap<>();

        //DEFAULT VALUE
        ElementDefinition defaultValue = _formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_DEFAULT_VALUE, ModelItemTypeConstants.STRING_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_DEFAULT_VALUE", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_DEFAULT_VALUE_DESC", new DefaultValidator(null, true));
        _autoFillItems.put(ATTRIBUTE_DEFAULT_VALUE, defaultValue);
        
        return _autoFillItems;
    }

    public List<ViewItem> getViewElements()
    {
        List<ViewItem> viewElements = new ArrayList<>();
        
        ViewElement defaultValue = new ViewElement();
        defaultValue.setDefinition((ElementDefinition< ? >) _autoFillItems.get(ATTRIBUTE_DEFAULT_VALUE));
        viewElements.add(defaultValue);
        
        return viewElements;
    }

    public boolean isCacheable(FormQuestion question)
    {
        return true;
    }

}
