/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import java.util.List;

import org.ametys.cms.data.File;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;

/**
 * Provide all the necessary method to add an illustration to a question type
 */
public interface IllustrableAwareQuestionType
{
    /** Constant for picture data attribute. */
    public static final String ATTRIBUTE_PICTURE = "picture";
    /** Constant for picture alternative attribute. */
    public static final String ATTRIBUTE_PICTURE_ALTERNATIVE = "picture-alternative";
    
    /**
     * Provide a list of model items that must be included in the model items return by the method FormQuestionType.getModel
     * @return a list of model items
     */
    public List<ModelItem> getIllustrationModelItems();
    
    /**
     * Get the view's common illustration tab
     * @param model the model of the question type
     * @return the illustration tab as SimpleViewItemGroup
     */
    public SimpleViewItemGroup getIllustrationTab(Model model);
    
    /**
     * Get the question illustration
     * @param question the question
     * @return the illustration
     */
    public File getIllustration(FormQuestion question);
    
    /**
     * Get the alternative of illustration
     * @param question the question
     * @return the alternative of illustration
     */
    public String getIllustrationAlternative(FormQuestion question);
}
