/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.parameter.Validator;

/**
 * Provide all the necessary method to make a question type required or not
 */
public interface MandatoryAwareQuestionType
{
    /** Constant for mandatory attribute. */
    public static final String ATTRIBUTE_MANDATORY = "mandatory";
    
    /**
     * Get the model item to add to the model items return by the method FormQuestionType.getModel
     * @return the model item
     */
    public ModelItem getMandatoryModelItem();
    
    /**
     * Create a view element to add in the view elements returned by FormQuestionType.getView
     * @param model the model link to the view
     * @return a view element
     */
    public ViewElement getMandatoryViewElement(Model model);
    
    /**
     * Create a validator that should be added to the element definition return by FormQuestionType.getEntryModel
     * @param question the question
     * @return a validator
     */
    public Validator getMandatoryValidator(FormQuestion question);

    /**
     * Check if the question is mandatory
     * @param question the question to check
     * @return true if the question is mandatory
     */
    public boolean isMandatory(FormQuestion question);
}
