/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.rights;

import java.util.HashSet;
import java.util.Set;

import org.ametys.core.right.RightContextConvertor;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormQuestion;

/**
 * This implementation converts a {@link FormPage} or {@link FormQuestion} or {@link FormEntry} into a {@link Form}
 */
public class FormElement2FormRightContextConvertor implements RightContextConvertor
{
    @Override
    public Set<Object> convert(Object object)
    {
        Set<Object> convertedObjects = new HashSet<>();
        
        if (object instanceof FormPage)
        {
            return Set.of(((FormPage) object).getForm());
        }
        else if (object instanceof FormQuestion)
        {
            return Set.of(((FormQuestion) object).getForm());
        }
        else if  (object instanceof FormEntry)
        {
            return Set.of(((FormEntry) object).getForm());
        }
        
        return convertedObjects;
    }
}
