/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This is not really an override, but it override many features that fills the widgetManager, so everything is here (most code is generated in XSL normally)
 */
Ametys.form.WidgetManager._defaultWidgets = {
    "non-enumeration":
        {
            "single":
            {
                "date": "edition.date",
                "string": "edition.textfield",
                "double": "edition.doublefield",
                "content": "edition.select-content",
                "long": "edition.longfield",
                "url": "edition.textfield",
                //"reference": "edition.url-reference",
                "datetime": "edition.datetime",
                //"password": "edition.password",
                "boolean": "edition.checkbox",
                "file": "edition.file",
                //"composite": "edition.repeater",
                "rich-text": "edition.richtext",
                //"geocode": "edition.geocode",
                "multilingual-string": "edition.multilingual-string",
                //"sub_content": "edition.compose-content",
                //"user": "edition.user",
                //"repeater": "edition.repeater"
            },
            "multiple":
            {
                //"reference": "edition.url-reference",
                "string": "edition.textfield",
                //"composite": "edition.repeater",
                "double": "edition.doublefield-multi",
                //"sub_content": "edition.compose-content",
                //"user": "edition.user",
                "content": "edition.select-content",
                //"url": "edition.textfield",
                "long": "edition.longfield-multi",
                //"repeater": "edition.repeater"
            }
        },
    "enumeration":
        {
            "single":
            {
                "string": "edition.combobox",
                //"content": "edition.select-content-with-enumeration"
            },
            "multiple":
            {
                "string": "edition.combobox",
                //"content": "edition.select-content-with-enumeration"
            }
        }
    };
    
    var widgetsFO = [
        // Text
	    {
	        enumerated: [false],
	        multiple: [true, false],
	        type: 'edition.textfield',
	        ftypes: ['string','multilingual-string'],
	        className: 'Ametys.form.widget.Text'
	    },
        // Combo
        {
            enumerated: [true, false],
            multiple: [true, false],
            type: 'edition.combobox',
            ftypes: ['string','long', 'boolean', 'double'],
            className: 'Ametys.form.widget.ComboBox'
        },
        // Boolean combo
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.boolean-combobox',
            ftypes: ['boolean'],
            className: 'Ametys.form.widget.BooleanCombobox'
        },
        // Long
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.longfield',
            ftypes: ['long'],
            className: 'Ametys.form.widget.Long'
        },
        // Double
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.doublefield',
            ftypes: ['double'],
            className: 'Ametys.form.widget.Double'
        },
        // Double multi
        {
            enumerated: [false],
            multiple: [true],
            type: 'edition.doublefield-multi',
            ftypes: ['double'],
            className: 'Ametys.form.widget.DoubleMulti'
        },
        // Checkbox
        {
            enumerated: [false],
            multiple: [true],
            type: 'edition.checkbox',
            ftypes: ['boolean'],
            className: 'Ametys.form.widget.Checkbox'
        },
        // Datetime
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.datetime',
            ftypes: ['datetime'],
            className: 'Ametys.form.widget.DateTime'
        },
        // String time
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.string-time',
            ftypes: ['string'],
            className: 'Ametys.form.widget.StringTime'
        },
        // Date
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.date',
            ftypes: ['date', 'datetime'],
            className: 'Ametys.form.widget.Date'
        },
        // Long multi
        {
            enumerated: [false],
            multiple: [true],
            type: 'edition.longfield-multi',
            ftypes: ['long'],
            className: 'Ametys.form.widget.LongMulti'
        },
        // Textarea
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.textarea',
            ftypes: ['string'],
            className: 'Ametys.form.widget.TextArea'
        },
        // File
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.file',
            ftypes: ['file'],
            className: 'Ametys.form.widget.File'
        },
        // Image
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.file',
            ftypes: ['file'],
            widget: 'edition.image',
            className: 'Ametys.form.widget.Image'
        },
        // Richtext 
        {
            enumerated: [false],
            multiple: [false],
            type: 'edition.richtext',
            ftypes: ['rich-text'],
            className: 'Ametys.cms.form.widget.RichText'
        },
        // Content
         {
            enumerated: [false],
            multiple: [true, false],
            type: 'edition.select-content',
            ftypes: ['content'],
            className: 'Ametys.cms.form.widget.SelectContent'
        },
        {
            enumerated: [false],
            multiple: [true, false],
            type: 'edition.select-referencetable-content',
            ftypes: ['content'],
            className: 'Ametys.cms.form.widget.SelectReferenceTableContent'
        }
    ];
    
    // Register FO widgets
    for (var w = 0; w < widgetsFO.length; w++)
    {
        var widget = widgetsFO[w];
        var id = widget.widget ? widget.widget : widget.type;
        
        Ext.ClassManager.aliasToName["widget." + id] = widget.className;
        Ext.ClassManager.nameToAliases[widget.className] = Ext.Array.from(Ext.ClassManager.nameToAliases[widget.className]);
        Ext.ClassManager.nameToAliases[widget.className].push("widget." + id);
        
        for (var i = 0; i < widget.ftypes.length; i++)
	    {
	        for (var j = 0; j < widget.multiple.length; j++)
	        {
	            for (var k = 0; k < widget.enumerated.length; k++)
	            {
	                Ametys.form.WidgetManager.register(id, widget.ftypes[i], widget.enumerated[k], widget.multiple[j]);
	            }
	        }
	    }
    }
    
