<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:math="java.lang.Math"
                            exclude-result-prefixes="ametys math">

    <!-- 
        | Toolbar for content
         -->
    <xsl:template name="ametys-front-edition-content-toolbar">
        <xsl:param name="label"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_CONTENT_LABEL" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="content-id"/>
        <xsl:param name="zone-item-id"/>
        <xsl:param name="zone-name">default</xsl:param>
        <xsl:param name="edit-view-name">default-edition</xsl:param>
        <xsl:param name="items">['edit', 'status-history', 'current-step', {type: 'menu', items: ['workflow-action-3', 'workflow-action-4', 'workflow-action-7']}, 'workflow-action-10', {type: 'menu', label: '<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_MORE_MENU_LABEL" i18n:catalogue="plugin.front-edition"/>', items: ['tag', 'move', 'remove']}]</xsl:param>
        <xsl:param name="workflow-actions">[3,4,7,10]</xsl:param><!-- propose, validate, refuse, unpublish -->
        <xsl:param name="workflow-steps">{"1": {"type": "neutral", "icon": "fas fa-file-alt"}, "2": {"type": "positive"}, "3": {"type": "positive"}}</xsl:param><!--  draft, proposed, validated -->
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:param name="excluded-actions-outside-edition-mode">[10]</xsl:param><!--  array of action id to exclude it if not in edition mode -->
        <xsl:param name="uniqueId" select="substring-after(math:random(), '.')" />
        
        <xsl:variable name="locale" select="ametys:translate('plugin.core-ui:PLUGINS_CORE_UI_LANGUAGE_CODE', ametys:lang())"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and ametys-front-edition:hasFrontEditionRight() and (not($edition-mode-only) or ametys:isEditionMode())">
            <div id="ametys-frontedition-content-tb-{$uniqueId}" class="ametys-front-edition-content-toolbar">
            </div>
            
            <script type="text/javascript">
                $j(function() {
                    var result = <xsl:value-of select="ametys-front-edition:getContentToolbarConfig($content-id, $zone-item-id, $workflow-actions, $workflow-steps, $locale, $edition-mode-only)"/>;
                    
                    AmetysFrontEditionContentToolbar.createContentToolbar('#ametys-frontedition-content-tb-<xsl:value-of select="$uniqueId"/>', {
                        label: "<xsl:copy-of select="$label"/>",
                        contentId: "<xsl:value-of select="$content-id"/>",
                        zoneName: "<xsl:value-of select="$zone-name"/>",
                        zoneItemId: "<xsl:value-of select="$zone-item-id"/>",
                        editViewName: "<xsl:value-of select="$edit-view-name"/>",
                        items: <xsl:copy-of select="$items"/>,
                        actionStatus: result.actionStatus,
                        workflowActions: result.workflowActions || {},
                        availableWorkflowActions: result.availableWorkflowActions || [],
                        excludedWorkflowActionsOutsideEditionMode: <xsl:value-of select="$excluded-actions-outside-edition-mode"/>,
                        workflowSteps: <xsl:value-of select="$workflow-steps"/>,
                        statusHistory: result.statusHistory,
                        step: result.step,
                        status: result.status
                    });
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <!-- 
        | Toolbar for page
         -->
    <xsl:template name="ametys-front-edition-page-toolbar">
        <xsl:param name="label"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_PAGE_LABEL" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="page-id" select="ametys:pageId()"/>
        <xsl:param name="items">['edition-mode', 'add-content', 'add-page', {type: 'menu', label: "<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_MENU_LABEL"  i18n:catalogue="plugin.front-edition"/>", items: [ 'tag', 'rename', 'move', 'schedule-publication', 'delete']}]</xsl:param>
        <xsl:param name="add-contents-config">[]</xsl:param>
        <xsl:param name="add-page-config">{}</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and $page-id != '' and ametys-front-edition:hasFrontEditionRight()">
            <div id="ametys-frontedition-page-tb-{$uniqueId}" class="ametys-front-edition-page-toolbar">
                <script type="text/javascript">
                    $j(function() {
                        var result = <xsl:value-of select="ametys-front-edition:getPageToolbarConfig($page-id, $add-contents-config, $edition-mode-only)"/>;
                        
                        AmetysFrontEditionPageToolbar.createPageToolbar('#ametys-frontedition-page-tb-<xsl:value-of select="$uniqueId"/>', {
                            label: "<xsl:copy-of select="$label"/>",
                            pageId: "<xsl:value-of select="$page-id"/>",
                            items: <xsl:copy-of select="$items"/>,
                            actionStatus: result.actionStatus,
                            parentId: result.parentId,
                            title: result.title,
                            position: result.position,
                            addContentsConfig: <xsl:copy-of select="$add-contents-config"/>,
                            allowedContentTypes: result.allowedContentTypes,
                            addPageConfig: <xsl:value-of select="$add-page-config"/>
                        });
                    });
                </script>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>

