<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            exclude-result-prefixes="ametys">

    <xsl:import href="front-edition-toolbar.xsl"/>
    
    <xsl:template name="ametys-front-edition-head">
        <!-- 
            Can be 'false' to just load a few bootstraping js files. You will have to call: AmetysFrontEdition.start(); by yourself (or optionally AmetysFrontEdition.load();). 
            Can be 'start' to start watching over edition. You can optionally call AmetysFrontEdition.load(); by yourself. 
            Can be 'load' to 'start' and pre-load all js/css files to make first edition faster.
            Can be 'debug' to 'start' and pre-load all js/css files to make first edition faster, without using jquery load.
         -->
        <xsl:param name="start">start</xsl:param>
        <!-- Edit action Id -->
        <xsl:param name="editActionId">2</xsl:param>
        <xsl:param name="insertAttachmentActionId">12</xsl:param>
        <!-- true to enable the edition field by field, false otherwise -->
        <xsl:param name="enableSimpleMode">true</xsl:param>
        <!-- false to not compute the modifiable contents according current user rights -->
        <xsl:param name="computeModifiableContents" select="true()"/>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:param name="edition-button-content"></xsl:param>
        <xsl:param name="start-callback">function() { }</xsl:param>

        <xsl:param name="theme">/plugins/front-edition/resources/themes/theme-ametys-material</xsl:param>
        <xsl:param name="js-loading-html"><xsl:call-template name="ametys-front-edition-loading-div" /></xsl:param>

        <!-- front-edition is loaded if : 
                rendering context == front
            AND has front edition right -->
        <xsl:if test="ametys:renderingContext() = 'front' and ametys-front-edition:hasFrontEditionRight()">
            <link rel="stylesheet" href="{ametys:pluginResourceURL('front-edition', 'css/loading.css')}" type="text/css" />
            <link rel="stylesheet" href="{ametys:pluginResourceURL('front-edition', '/css/vendor/contextmenu/jquery.contextMenu.css')}" />
            <link rel="stylesheet" href="{ametys:pluginResourceURL('front-edition', '/scss/toolbar.css')}" />

            <xsl:variable name="sitemapLanguage" select="ametys:lang()"/>  
            
            <xsl:variable name="locale" select="ametys:translate('plugin.core-ui:PLUGINS_CORE_UI_LANGUAGE_CODE', $sitemapLanguage)"/>
            <xsl:variable name="cssHashCode" select="ametys-front-edition:prepareCSSFiles($locale, $theme)"/>
            <xsl:variable name="jsHashCode" select="ametys-front-edition:prepareJSFiles($locale, $theme)"/>
            
            <script src="{ametys:pluginResourceURL('front-edition', concat('js/front-edition.', $sitemapLanguage, '.js'))}" type="text/javascript"/>
            <script src="{ametys:pluginResourceURL('front-edition', concat('js/front-page.', $sitemapLanguage, '.js'))}" type="text/javascript"/>
            
            <script src="{ametys:pluginResourceURL('front-edition', '/js/vendor/contextmenu/jquery.contextMenu.js')}"></script>
            <script src="{ametys:pluginResourceURL('front-edition', '/js/vendor/contextmenu/jquery.ui.position.js')}"></script>
            <script src="{ametys:pluginResourceURL('front-edition', concat('/js/front-edition-toolbar-helper.', $sitemapLanguage, '.js'))}"></script>
            <script src="{ametys:pluginResourceURL('front-edition', concat('/js/front-edition-toolbar-content.', $sitemapLanguage, '.js'))}"></script>
            <script src="{ametys:pluginResourceURL('front-edition', concat('/js/front-edition-toolbar-page.', $sitemapLanguage, '.js'))}"></script>

            <script type="text/template" id="front-edition-loading-template">
                <xsl:copy-of select="$js-loading-html" />
            </script>
            <script type="text/javascript">
                AmetysFrontEdition.CONTEXT_PATH = "<xsl:value-of select="ametys:uriPrefix()"/>";
                AmetysFrontEdition.PAGE_PATH = "<xsl:value-of select="ametys:pagePath()"/>";
                AmetysFrontEdition.EDITION_MODE = <xsl:value-of select="ametys:isEditionMode()"/>;
                AmetysFrontEdition.SITECONTEXT_PATH = "<xsl:value-of select="ametys:siteUriPrefix()"/>";
                AmetysFrontEdition.LANG = "<xsl:value-of select="$sitemapLanguage"/>";
                AmetysFrontEdition.SITENAME = "<xsl:value-of select="ametys:site()"/>";
                AmetysFrontEdition.PAGEID = "<xsl:value-of select="ametys:pageId()"/>";
                AmetysFrontEdition.JS_HASHCODE = "<xsl:value-of select="$jsHashCode"/>";
                AmetysFrontEdition.CSS_HASHCODE = "<xsl:value-of select="$cssHashCode"/>";
                AmetysFrontEdition.editActionId = <xsl:value-of select="$editActionId"/>;
                AmetysFrontEdition.insertAttachmentActionId = <xsl:value-of select="$insertAttachmentActionId"/>;
                AmetysFrontEdition.enableSimpleMode = <xsl:value-of select="$enableSimpleMode"/>;
                <xsl:choose>
                    <xsl:when test="$enableSimpleMode = 'true' and $computeModifiableContents">
                        AmetysFrontEdition.modifiableContents = <xsl:value-of select="ametys-front-edition:getModifiableContents($editActionId, ametys:pageId(), $edition-mode-only)"/>;
                    </xsl:when>
                    <xsl:otherwise>
                       AmetysFrontEdition.modifiableContents = {};
                    </xsl:otherwise>
                </xsl:choose>
                
                AmetysFrontEdition.FRONT_EDITION_JS_LOADING_HTML = $j("#front-edition-loading-template").html();

                window.ametys_opts = {
                    "plugins-direct-prefix": "/plugins",
                    "plugins-wrapped-prefix": "/_plugins",
                    "debug-mode": <xsl:value-of select="ametys:isDeveloperMode()"/>,
                    "context-path": AmetysFrontEdition.CONTEXT_PATH,
                    "workspace-name": "<xsl:value-of select="ametys:workspaceName()"/>",
                    "workspace-prefix": "<xsl:value-of select="ametys:workspacePrefix()"/>",
                    "max-upload-size": "<xsl:value-of select='ametys:config(&quot;runtime.upload.max-size&quot;)'/>",
                    "language-code": "<xsl:value-of select="$locale"/>",
                    "app-parameters": { 
                        "siteName": "<xsl:value-of select="ametys:site()"/>",
                        "lang": "<xsl:value-of select="$sitemapLanguage"/>",  
                        "pageId": "<xsl:value-of select="ametys:pageId()"/>",
                        "locale": "<xsl:value-of select="$locale"/>" // need locale for server request
                    }
                }

                <!-- JS is executed if simpleMode == true OR we are in edition mode -->
                <xsl:if test="$enableSimpleMode = 'true' or ametys:isEditionMode()">
	                <xsl:choose>
	                    <xsl:when test="$start = 'start'">
	                        AmetysFrontEdition.start(<xsl:value-of select="$start-callback"/>);
	                    </xsl:when>
	                    <xsl:when test="$start = 'load'">
                        $j(window).on("load", function() {
	                        AmetysFrontEdition.load(undefined, true, <xsl:value-of select="$start-callback"/>);
                        });
	                    </xsl:when>
	                    <xsl:when test="$start = 'debug'">
	                        AmetysFrontEdition.initialized = 0;
	                        AmetysFrontEdition.start(<xsl:value-of select="$start-callback"/>);
	                        AmetysFrontEdition.initialized = 3;
	                        AmetysFrontEdition.preInit();
	                    </xsl:when>
	                </xsl:choose>
                </xsl:if>
            </script>
            <xsl:if test="$start = 'debug'">
               <script type='text/javascript' src='{ametys:uriPrefix()}/_plugins/web/resources-minimized/{$jsHashCode}.js'></script>
               <link type='text/css' rel='stylesheet' href='{ametys:uriPrefix()}/_plugins/web/resources-minimized/{$cssHashCode}.css'></link>
               <xsl:if test="$enableSimpleMode = 'true' or ametys:isEditionMode()">
	               <script type='text/javascript'>
	                   AmetysFrontEdition.postInit();
	               </script>
               </xsl:if>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ametys-front-edition-loading-div">
        <div class="front-edition-loading-div">
            <div class="front-edition-loading-div-text">
                <i18n:text i18n:key="PLUGINS_FRONT_EDITION_LOADING_TEXT" i18n:catalogue="plugin.front-edition"/>
            </div>
        </div>
    </xsl:template>

    <!-- Toggle edition/normal -->
    <xsl:template name="ametys-front-edition-insert-toggle-edition-mode-button">
        <xsl:param name="class">front-edition-toggle-edition-mode</xsl:param>
        <xsl:if test="ametys:renderingContext() = 'front' and ametys:pagePath() != '' and ametys-front-edition:hasFrontEditionRight()">
            <xsl:choose>
                <xsl:when test="ametys:isCacheable()"></xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="ametys-front-edition-insert-toggle-edition-mode-button-check-mode">
                        <xsl:with-param name="class" select="$class"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-toggle-edition-mode-button-check-mode">
        <xsl:param name="class"/>
        <xsl:variable name="edition-mode-button-text">
            <xsl:choose>
                <xsl:when test="ametys:isEditionMode()"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_EDITION_MODE_LEAVE" i18n:catalogue="plugin.front-edition"/></xsl:when>
                <xsl:otherwise><i18n:text i18n:key="PLUGINS_FRONT_EDITION_EDITION_MODE_ENTER" i18n:catalogue="plugin.front-edition"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="title-i18n">
            <xsl:choose>
                <xsl:when test="ametys:isEditionMode()">plugin.front-edition:PLUGINS_FRONT_EDITION_EDITION_MODE_LEAVE_TITLE</xsl:when>
                <xsl:otherwise>plugin.front-edition:PLUGINS_FRONT_EDITION_EDITION_MODE_ENTER_TITLE</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="ametys-front-edition-insert-toggle-edition-mode-button-simple">
            <xsl:with-param name="edition-mode-button-text" select="$edition-mode-button-text"/>
            <xsl:with-param name="javascript-function">AmetysFrontEdition.toggleEditionMode()</xsl:with-param>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-toggle-edition-mode-button-simple">
        <xsl:param name="edition-mode-button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$edition-mode-button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Page status (validated/draft/mixed) -->
    <xsl:template name="ametys-front-edition-get-page-status">
        <xsl:param name="page-id"/>
        <xsl:param name="prefix"/>
        <xsl:if test="ametys:isEditionMode()">
            <xsl:value-of select="$prefix"/><xsl:value-of select="ametys-front-edition:getPageStatus($page-id)"></xsl:value-of>
        </xsl:if>
    </xsl:template>

    <!-- Content workflow step -->
    <xsl:template name="ametys-front-edition-get-content-workflow-step">
        <xsl:param name="content-id"/>
        <xsl:param name="prefix"/>
        <xsl:if test="ametys:isEditionMode()">
            <xsl:value-of select="$prefix"/><xsl:value-of select="ametys-front-edition:getContentWorkflowId($content-id)"></xsl:value-of>
        </xsl:if>
    </xsl:template>
    <!-- Content workflow validated -->
    <xsl:template name="ametys-front-edition-get-content-validation-status">
        <xsl:param name="content-id"/>
        <xsl:param name="prefix"/>
        <xsl:if test="ametys:isEditionMode()">
            <xsl:value-of select="$prefix"/><xsl:value-of select="ametys-front-edition:getContentStatus($content-id)"></xsl:value-of>
        </xsl:if>
    </xsl:template>

    <!-- Create Page -->
    <xsl:template name="ametys-front-edition-insert-create-page-button">
        <xsl:param name="page-id"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_CREATE_PAGE_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_CREATE_PAGE_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-add-page</xsl:param>
        <xsl:param name="callback"></xsl:param>
        <xsl:param name="config">{}</xsl:param>
        <xsl:param name="class">front-edition-add-page</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Create', $page-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.createPage('<xsl:value-of select="$page-id" />', <xsl:value-of select="$config" />, <xsl:value-of select="$callback" />)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-create-page-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-create-page-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Delete Page -->
    <xsl:template name="ametys-front-edition-insert-delete-page-button">
        <xsl:param name="page-id"/>
        <xsl:param name="page-title"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_DELETE_PAGE_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_DELETE_PAGE_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-delete-page</xsl:param>
        <xsl:param name="js-texts-confirm-title"></xsl:param>
        <xsl:param name="js-texts-confirm-text"></xsl:param>
        <xsl:param name="js-texts-confirm-orphan-text"></xsl:param>
        <xsl:param name="js-texts-confirm-orphan-title"></xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:param name="callback"></xsl:param>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Delete', $page-id, $edition-mode-only)">
            <xsl:variable name="escapedTitle" select="ametys:escapeJS($page-title)"></xsl:variable>
            <xsl:variable name="textJson">{
            "confirm_title" : "<xsl:value-of select="$js-texts-confirm-title"/>",
            "confirm_text" : "<xsl:value-of select="$js-texts-confirm-text"/>",
            "confirm_orphan_title" : "<xsl:value-of select="$js-texts-confirm-orphan-text"/>",
            "confirm_orphan_text" : "<xsl:value-of select="$js-texts-confirm-orphan-title" />"
            }</xsl:variable>
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.deletePage('<xsl:value-of select="$page-id" />', '<xsl:value-of select="$escapedTitle" />', <xsl:value-of select="$textJson" />, <xsl:value-of select="$callback"/>)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-delete-page-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-delete-page-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Rename Page -->
    <xsl:template name="ametys-front-edition-insert-rename-page-button">
        <xsl:param name="page-id"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_RENAME_PAGE_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_RENAME_PAGE_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-rename-page</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Rename', $page-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.renamePage('<xsl:value-of select="$page-id" />')</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-rename-page-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-rename-page-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Move Page -->
    <xsl:template name="ametys-front-edition-insert-move-page-up-button">
        <xsl:param name="page-id"/>
        <xsl:param name="page-parent-id"/>
        <xsl:param name="page-pos"/>
        <xsl:param name="page-title"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_MOVE_PAGE_UP_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_MOVE_PAGE_UP_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-move-page-up</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="$page-pos > 1">
            <xsl:variable name="page-new-pos"><xsl:value-of select="$page-pos - 2"/></xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-move-page-button">
                <xsl:with-param name="page-id" select="$page-id"/>
                <xsl:with-param name="page-parent-id" select="$page-parent-id"/>
                <xsl:with-param name="page-new-pos" select="$page-new-pos"/>
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="page-title" select="$page-title"/>
                <xsl:with-param name="link-title-i18n" select="$title-i18n"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="edition-mode-only" select="$edition-mode-only"/>
            </xsl:call-template>
         </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-move-page-down-button">
        <xsl:param name="page-id"/>
        <xsl:param name="page-parent-id"/>
        <xsl:param name="page-pos"/>
        <xsl:param name="page-title"/>
        <xsl:param name="number-of-pages"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_MOVE_PAGE_DOWN_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_MOVE_PAGE_DOWN_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-move-page-down</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="$page-pos &lt; $number-of-pages">
            <xsl:variable name="page-new-pos"><xsl:value-of select="$page-pos + 1"/></xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-move-page-button">
                <xsl:with-param name="page-id" select="$page-id"/>
                <xsl:with-param name="page-parent-id" select="$page-parent-id"/>
                <xsl:with-param name="page-new-pos" select="$page-new-pos"/>
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="page-title" select="$page-title"/>
                <xsl:with-param name="link-title-i18n" select="$title-i18n"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="edition-mode-only" select="$edition-mode-only"/>
            </xsl:call-template>
         </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-move-page-button">
        <xsl:param name="page-id"/>
        <xsl:param name="page-parent-id"/>
        <xsl:param name="page-new-pos"/>
        <xsl:param name="button-text"/>
        <xsl:param name="page-title"/>
        <xsl:param name="class"/>
        <xsl:param name="link-title-i18n"/>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('', $page-id, $edition-mode-only)">
            <xsl:variable name="escapedTitle" select="ametys:escapeJS($page-title)"></xsl:variable>
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.movePage('<xsl:value-of select="$page-id" />', '<xsl:value-of select="$page-parent-id" />', <xsl:value-of select="$page-new-pos" />, '<xsl:value-of select="$escapedTitle" />')</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-move-page-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$link-title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-move-page-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Tag Page -->
    <xsl:template name="ametys-front-edition-insert-tag-page-button">
        <xsl:param name="page-id"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_TAG_PAGE_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_TAG_PAGE_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-tag-page</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Tag', $page-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.changePageTags('<xsl:value-of select="$page-id" />')</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-tag-page-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-tag-page-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Schedule Publication Page -->
    <xsl:template name="ametys-front-edition-insert-schedule-publication-button">
        <xsl:param name="page-id" select="ametys:pageId()"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_SCHEDULE_PAGE_PUBLICATION_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_SCHEDULE_PAGE_PUBLICATION_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-schedule-publication</xsl:param>
        <xsl:if test="ametys-front-edition:isPageModifiable($page-id) and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Schedule', $page-id, true())">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.schedulePublication('<xsl:value-of select="$page-id" />')</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-schedule-publication-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-schedule-publication-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Content Page -->
    <xsl:template name="ametys-front-edition-insert-tag-content-button">
        <xsl:param name="content-id"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_TAG_CONTENT_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_TAG_CONTENT_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-tag-content</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="$content-id != '' and ametys-front-edition:hasFrontEditionRight('CMS_Rights_Content_Tag', $content-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.changeContentTags('<xsl:value-of select="$content-id" />')</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-tag-content-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-insert-tag-content-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Content -->
    <xsl:template name="ametys-front-edition-add-content-button">
        <xsl:param name="page-id"/>
        <xsl:param name="content-types"/>
        <xsl:param name="zone-name">default</xsl:param>
        <xsl:param name="content-title">plugin.front-edition:PLUGINS_FRONT_EDITION_DEFAULT_CONTENT_NAME</xsl:param>
        <xsl:param name="init-workflow-action-id">1</xsl:param>
        <xsl:param name="workflow-name">content</xsl:param>
        <xsl:param name="lang"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_ADD_CONTENT_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_ADD_CONTENT_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-add-content</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_AddContent', $page-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.addContent({
    pageId:'<xsl:value-of select="$page-id" />',
    zoneName:'<xsl:value-of select="$zone-name" />',
    contentTypes:'<xsl:value-of select="$content-types" />',
    contentTitle:'<xsl:value-of select="ametys:escapeJS(ametys:translate($content-title))" />',
    lang:'<xsl:value-of select="$lang" />',
    initWorkflowActionId:'<xsl:value-of select="$init-workflow-action-id" />',
    workflowName:'<xsl:value-of select="$workflow-name" />'
})</xsl:variable>
            <xsl:call-template name="ametys-front-edition-add-content-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-add-content-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ametys-front-edition-remove-zoneitem-button">
        <xsl:param name="page-id"/>
        <xsl:param name="zone-name">default</xsl:param>
        <xsl:param name="zone-item-id"/>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_REMOVE_CONTENT_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_REMOVE_CONTENT_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-remove-content</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_DeleteZoneItem', $page-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.removeZoneItem({
    pageId:'<xsl:value-of select="$page-id" />',
    zoneName:'<xsl:value-of select="$zone-name" />',
    zoneItemId:'<xsl:value-of select="$zone-item-id" />'
})</xsl:variable>
            <xsl:call-template name="ametys-front-edition-add-content-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-remove-zoneitem-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="ametys-front-edition-content-workflow-button">
        <xsl:param name="content-id"/>
        <xsl:param name="workflow-id"/>
        <xsl:param name="workflow-text"/>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_EMPTY_TEXT</xsl:param>
        <xsl:param name="class">front-edition-workflow-action</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="$workflow-id != ''">
            <xsl:if test="ametys-front-edition:hasWorkflowRight($workflow-id, $content-id, $edition-mode-only)">
                <xsl:variable name="button-text">
		            <xsl:choose>
                        <xsl:when test="$workflow-text"><xsl:copy-of select="$workflow-text"/></xsl:when>
		                <xsl:otherwise><xsl:value-of select="ametys-front-edition:getWorkflowName('content', $workflow-id)" /></xsl:otherwise>
		            </xsl:choose>
		        </xsl:variable>
	            <xsl:variable name="javascript-function">AmetysFrontEdition.execWorkflowAction('<xsl:value-of select="$content-id" />', <xsl:value-of select="$workflow-id" />)</xsl:variable>
	            <xsl:call-template name="ametys-front-edition-content-workflow-button-simple">
	                <xsl:with-param name="button-text" select="$button-text"/>
	                <xsl:with-param name="javascript-function" select="$javascript-function"/>
	                <xsl:with-param name="class" select="$class"/>
	                <xsl:with-param name="title-i18n" select="$title-i18n"/>
	            </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-content-workflow-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="ametys-front-edition-edit-content-button">
        <xsl:param name="content-id"/>
        <xsl:param name="workflow-ids">[2]</xsl:param>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_EDIT_CONTENT_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_EDIT_CONTENT_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-edit-content</xsl:param>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:if test="$workflow-ids != '' and ametys-front-edition:hasFrontEditionRight('Workflow_Rights_Edition_Online', $content-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.editElements('<xsl:value-of select="$content-id" />', <xsl:value-of select="$workflow-ids" />)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-edit-content-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-edit-content-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    <!-- Edit content in popup -->
    <xsl:template name="ametys-front-edition-edit-content-in-popup-button">
        <xsl:param name="content-id"/>
        <xsl:param name="view-name">default-edition</xsl:param>
        <xsl:param name="button-text"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_EDIT_CONTENT_BUTTON" i18n:catalogue="plugin.front-edition"/></xsl:param>
        <xsl:param name="title-i18n">plugin.front-edition:PLUGINS_FRONT_EDITION_EDIT_CONTENT_BUTTON_TITLE</xsl:param>
        <xsl:param name="class">front-edition-edit-content</xsl:param>
        <xsl:param name="callback"/>
        <xsl:param name="edition-mode-only" select="false()"/>
        <xsl:if test="ametys-front-edition:hasFrontEditionRight('Workflow_Rights_Edition_Online', $content-id, $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.editContent('<xsl:value-of select="$content-id" />', '<xsl:value-of select="$view-name" />', <xsl:value-of select="$callback" />)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-insert-button-simple">
                <xsl:with-param name="button-text" select="$button-text"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="title-i18n" select="$title-i18n"/>
                <xsl:with-param name="style" select="'display: none;'"/>
                <xsl:with-param name="id" select="concat('btn-edit-content-', generate-id())"/>
            </xsl:call-template>
            
            <script type="text/javascript">
                (function (){
                    AmetysFrontEdition.updateModifiableContents(['<xsl:value-of select="$content-id"/>'], function() {
                        if (AmetysFrontEdition.modifiableContents['<xsl:value-of select="$content-id"/>'])
                        {
                            var btn = $j('#btn-edit-content-<xsl:value-of select="generate-id()"/>')
                            btn.show();
                        }
                    })
                })();
            </script>
        </xsl:if>
    </xsl:template>

    <!-- Move content -->
    <xsl:template name="ametys-front-edition-move-content-button">
        <xsl:param name="zone-item-id"/>
        <xsl:param name="zone-name"/>
        <xsl:param name="offset"/>
        <xsl:param name="button-text"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="class"/>
        <xsl:param name="edition-mode-only" select="true()"/>
        
        <xsl:if test="$zone-item-id != '' and ametys:pageId() != '' and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_OrganizeZoneItem', '')">
	        <xsl:choose>
	            <xsl:when test="$offset &lt; 0 and ametys-front-edition:getZoneItemPosition($zone-item-id)  + $offset >= 0">
	                <xsl:call-template name="ametys-front-edition-move-content-button-up">
	                 <xsl:with-param name="zone-item-id" select="$zone-item-id"/>
	                 <xsl:with-param name="zone-name" select="$zone-name"/>
	                 <xsl:with-param name="offset" select="$offset"/>
	                 <xsl:with-param name="button-text" select="$button-text"/>
	                 <xsl:with-param name="title-i18n" select="$title-i18n"/>
	                 <xsl:with-param name="class" select="$class"/>
	                 <xsl:with-param name="edition-mode-only" select="$edition-mode-only"/>
	                </xsl:call-template>
	            </xsl:when>
	            <xsl:when test="$offset > 0 and ametys-front-edition:getZoneItemPosition($zone-item-id) + $offset &lt; ametys-front-edition:getZoneSize($zone-name, ametys:pageId())">
	                <xsl:call-template name="ametys-front-edition-move-content-button-down">
	                 <xsl:with-param name="zone-item-id" select="$zone-item-id"/>
	                 <xsl:with-param name="zone-name" select="$zone-name"/>
	                 <xsl:with-param name="offset" select="$offset"/>
	                 <xsl:with-param name="button-text" select="$button-text"/>
	                 <xsl:with-param name="title-i18n" select="$title-i18n"/>
	                 <xsl:with-param name="class" select="$class"/>
	                 <xsl:with-param name="edition-mode-only" select="$edition-mode-only"/>
	                </xsl:call-template>
	            </xsl:when>
	        </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-move-content-button-up">
        <xsl:param name="zone-item-id"/>
        <xsl:param name="zone-name"/>
        <xsl:param name="offset"/>
        <xsl:param name="button-text"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="class"/>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:variable name="button-text2">
            <xsl:choose>
                <xsl:when test="not($button-text)">
                    <i18n:text i18n:key="PLUGINS_FRONT_EDITION_MOVE_CONTENT_UP" i18n:catalogue="plugin.front-edition"/>
                </xsl:when>
                <xsl:otherwise>
                   <xsl:copy-of select="$button-text"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="title-i18n2">
            <xsl:choose>
                <xsl:when test="not($title-i18n)">plugin.front-edition:PLUGINS_FRONT_EDITION_MOVE_CONTENT_UP_TITLE</xsl:when>
                <xsl:otherwise>
                   <xsl:value-of select="$title-i18n"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="class2">
            <xsl:choose>
                <xsl:when test="not($class)">front-edition-move-content-up</xsl:when>
                <xsl:otherwise>
                   <xsl:value-of select="$class"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:if test="$zone-item-id != '' and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_OrganizeZoneItem', '', $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.moveZoneItem('<xsl:value-of select="$zone-item-id" />', '<xsl:value-of select="$zone-name" />', <xsl:value-of select="$offset" />)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-move-content-button-up-simple">
                <xsl:with-param name="button-text" select="$button-text2"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="title-i18n" select="$title-i18n2"/>
                <xsl:with-param name="class" select="$class2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-move-content-button-up-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="class"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ametys-front-edition-move-content-button-down">
        <xsl:param name="zone-item-id"/>
        <xsl:param name="zone-name"/>
        <xsl:param name="offset"/>
        <xsl:param name="button-text"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="class"/>
        <xsl:param name="edition-mode-only" select="true()"/>
        <xsl:variable name="button-text2">
            <xsl:choose>
                <xsl:when test="not($button-text)"><i18n:text i18n:key="PLUGINS_FRONT_EDITION_MOVE_CONTENT_DOWN" i18n:catalogue="plugin.front-edition"/></xsl:when>
                <xsl:otherwise><xsl:copy-of select="$button-text"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="title-i18n2">
            <xsl:choose>
                <xsl:when test="not($title-i18n)">plugin.front-edition:PLUGINS_FRONT_EDITION_MOVE_CONTENT_DOWN_TITLE</xsl:when>
                <xsl:otherwise>
                   <xsl:value-of select="$title-i18n"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="class2">
            <xsl:choose>
                <xsl:when test="not($class)">front-edition-move-content-down</xsl:when>
                <xsl:otherwise>
                   <xsl:value-of select="$class"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:if test="$zone-item-id != '' and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_OrganizeZoneItem', '', $edition-mode-only)">
            <xsl:variable name="javascript-function">AmetysFrontEdition.page.moveZoneItem('<xsl:value-of select="$zone-item-id" />', '<xsl:value-of select="$zone-name" />', <xsl:value-of select="$offset" />)</xsl:variable>
            <xsl:call-template name="ametys-front-edition-move-content-button-down-simple">
                <xsl:with-param name="button-text" select="$button-text2"/>
                <xsl:with-param name="javascript-function" select="$javascript-function"/>
                <xsl:with-param name="title-i18n" select="$title-i18n2"/>
                <xsl:with-param name="class" select="$class2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="ametys-front-edition-move-content-button-down-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="class"/>
        <xsl:call-template name="ametys-front-edition-insert-button-simple">
            <xsl:with-param name="button-text" select="$button-text"/>
            <xsl:with-param name="javascript-function" select="$javascript-function"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="title-i18n" select="$title-i18n"/>
        </xsl:call-template>
    </xsl:template>
    <!-- Common Button -->
    <xsl:template name="ametys-front-edition-insert-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="style"/>
        <xsl:param name="id"/>
            <a class="{$class}" title="{$title-i18n}" i18n:attr="title" href="javascript:void(0)" onclick="{$javascript-function}">
                <xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
                <xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
                <span><xsl:copy-of select="$button-text"/></span>
            </a>
    </xsl:template>

</xsl:stylesheet>

