/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.frontedition;

import java.util.List;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.frontedition.AmetysFrontEditionHelper;
import org.ametys.plugins.frontedition.FrontEditionHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class DispatchGenerator
extends org.ametys.core.ui.dispatcher.DispatchGenerator {
    private static final List<String> __UNPROTECTED_FOEDITION_METHODS = List.of("pageExists");
    private AmetysObjectResolver _resolver;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    protected void _setContextInRequestAttributes(Map<String, Object> contextAsMap) {
        String pageId;
        super._setContextInRequestAttributes(contextAsMap);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (contextAsMap.containsKey("pageId") && !StringUtils.isBlank((CharSequence)(pageId = (String)contextAsMap.get("pageId")))) {
            try {
                Page page = (Page)this._resolver.resolveById(pageId);
                request.setAttribute(Page.class.getName(), (Object)page);
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().debug("Page with id '" + pageId + "' does not exist anymore. It may have been deleted or unpublished after recent modifications");
            }
        }
        request.setAttribute("locale", contextAsMap.get("locale"));
        request.setAttribute("can-come-from-front", (Object)true);
    }

    protected String _createUrl(String pluginOrWorkspace, String relativeUrl, Map<String, Object> requestParameters) {
        if (!this._skipRightProtection(relativeUrl, requestParameters) && !AmetysFrontEditionHelper.hasFrontEditionRight()) {
            throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " is not allowed to access front edition");
        }
        return super._createUrl(pluginOrWorkspace, relativeUrl, requestParameters);
    }

    private boolean _skipRightProtection(String relativeUrl, Map<String, Object> requestParameters) {
        if ("client-call".equals(relativeUrl)) {
            String methodName = (String)requestParameters.get("methodName");
            String role = (String)requestParameters.get("role");
            if (FrontEditionHelper.ROLE.equals(role) && __UNPROTECTED_FOEDITION_METHODS.contains(methodName)) {
                return true;
            }
        }
        return false;
    }

    protected Map<String, Object> transmitAttributes(Map<String, Object> attributes) {
        Map transmitAttributes = super.transmitAttributes(attributes);
        if (attributes.containsKey("Web:FrontOffice:UserIdentity")) {
            UserIdentity frontUserIdentity = (UserIdentity)attributes.get("Web:FrontOffice:UserIdentity");
            transmitAttributes.put("Web:FrontOffice:UserIdentity", frontUserIdentity);
        }
        if (attributes.containsKey("rendering-context")) {
            transmitAttributes.put("rendering-context", attributes.get("rendering-context"));
        }
        if (attributes.containsKey("can-come-from-front")) {
            transmitAttributes.put("can-come-from-front", attributes.get("can-come-from-front"));
        }
        if (attributes.containsKey("site")) {
            transmitAttributes.put("site", attributes.get("site"));
        }
        return transmitAttributes;
    }

    protected String _exceptionToStackTraceInformation(Throwable t) {
        if (DevMode.getDeveloperMode() == DevMode.DEVMODE.PRODUCTION) {
            return "The exception is hidden for security purposes";
        }
        return super._exceptionToStackTraceInformation(t);
    }
}

