/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.frontedition;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.frontedition.AmetysFrontEditionHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class FrontEditionHelper
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = FrontEditionHelper.class.getName();
    private AmetysObjectResolver _ametysObjectResolver;
    private ZoneDAO _zoneDAO;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._ametysObjectResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._zoneDAO = (ZoneDAO)manager.lookup(ZoneDAO.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Front_Edition_Access_Right"}, paramIndex=0, rightContext="right.assignment.context.pageaccess")
    public String firstAvailableParentInLivePath(String pageId) {
        AmetysObject resolveById = this._ametysObjectResolver.resolveById(pageId);
        if (resolveById instanceof Page) {
            Page page = (Page)resolveById;
            return this.firstAvailableParentInLivePath(page);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String firstAvailableParentInLivePath(Page page) {
        Request request = ContextHelper.getRequest((Context)this._context);
        if (page == null) {
            return "";
        }
        Page available = page;
        Page availablePage = null;
        boolean found = false;
        String forcedWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
            while (!found) {
                try {
                    AmetysObject resolveById = this._ametysObjectResolver.resolveById(available.getId());
                    if (resolveById != null) {
                        found = true;
                        continue;
                    }
                    available = available.getParent();
                }
                catch (UnknownAmetysObjectException e) {
                    available = available.getParent();
                }
            }
            if (available instanceof Page) {
                availablePage = available;
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)forcedWorkspace);
        }
        return availablePage == null ? "" : availablePage.getPathInSitemap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"*"})
    public boolean pageExists(String pageId, boolean editionMode) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)(editionMode ? "default" : "live"));
            boolean bl = this._ametysObjectResolver.hasAmetysObjectForId(pageId);
            return bl;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
        }
    }

    @Callable(rights={""})
    public Map<Integer, String> getWorkflowActionName(String contentId, String workflowName, List<Integer> actionIds) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (Integer actionId : actionIds) {
            boolean hasWorkflowRight = AmetysFrontEditionHelper.hasWorkflowRight(actionId, contentId, false);
            if (!hasWorkflowRight) continue;
            String translatedName = AmetysFrontEditionHelper.getWorkflowName(workflowName, actionId);
            result.put(actionId, translatedName);
        }
        return result;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getModifiableContents(int actionId, List<String> contentIds, boolean checkEditionMode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String contentId : contentIds) {
            Content content = (Content)this._ametysObjectResolver.resolveById(contentId);
            HashMap<String, Object> contentInfo = new HashMap<String, Object>();
            contentInfo.put("unmodifiableAttributes", AmetysFrontEditionHelper.getUnmodifiableAttributes(content, List.of(Integer.valueOf(actionId)), checkEditionMode));
            contentInfo.put("rights", AmetysFrontEditionHelper.getRightsForContent(content));
            result.put(contentId, contentInfo);
        }
        return result;
    }

    @Callable(rights={""})
    public boolean moveZoneItemId(String zoneItemId, String zoneName, String pageId, int offset) throws UnknownAmetysObjectException, AmetysRepositoryException, RepositoryException, AccessDeniedException {
        ZoneItem zoneItem = (ZoneItem)this._ametysObjectResolver.resolveById(zoneItemId);
        AmetysObject parent = zoneItem.getParent();
        if (parent instanceof DefaultTraversableAmetysObject) {
            SitemapElement page = zoneItem.getZone().getSitemapElement();
            if (!AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_OrganizeZoneItem", (AmetysObject)page, false)) {
                throw new AccessDeniedException("User try to move zone item without sufficient right");
            }
            DefaultTraversableAmetysObject traversableParent = (DefaultTraversableAmetysObject)parent;
            long itemPosition = traversableParent.getChildPosition((AmetysObject)zoneItem);
            long targetPosition = itemPosition + (long)offset;
            ZoneItem targetZoneItem = (ZoneItem)traversableParent.getChildAt(targetPosition);
            return this._zoneDAO.moveZoneItemTo(zoneItemId, zoneName, offset < 0, targetZoneItem.getId(), pageId);
        }
        return false;
    }
}

