/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.frontedition;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockManager;
import org.ametys.cms.lock.LockContentManager;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.AvalonLoggerAdapter;
import org.ametys.plugins.core.ui.help.HelpManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.frontedition.AmetysFrontEditionHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class GetServerValuesAction
extends ServiceableAction
implements Initializable {
    protected Logger _logger;
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected RenderingContextHandler _renderingContextHandler;
    protected UserHelper _userHelper;
    protected LockContentManager _lockContentManager;
    protected HelpManager _helpManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._lockContentManager = (LockContentManager)serviceManager.lookup(LockContentManager.ROLE);
        this._helpManager = (HelpManager)serviceManager.lookup(HelpManager.ROLE);
    }

    public void initialize() throws Exception {
        this._logger = new AvalonLoggerAdapter(this.getLogger());
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String[] labels;
        RenderingContext context;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String contentId = parameters.getParameter("contentId");
        String attributePathsAsString = parameters.getParameter("metadataPaths");
        String workflowIdsAsString = parameters.getParameter("workflowIds", null);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        boolean success = true;
        if (attributePathsAsString == null) {
            success = false;
            jsonObject.put("error", "no metadata");
            request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
            return EMPTY_MAP;
        }
        List<String> attributePaths = Arrays.asList(attributePathsAsString.split(";"));
        boolean validateContent = parameters.getParameterAsBoolean("validateContent", false);
        boolean isEditionMode = "true".equals(request.getParameter("_edition"));
        validateContent &= !isEditionMode;
        Content content = (Content)this._resolver.resolveById(contentId);
        UserIdentity locker = this.isContentLocked(content);
        if (locker != null) {
            success = false;
            String userFullName = this._userHelper.getUserFullName(locker);
            jsonObject.put("error", "locked");
            HashMap<String, String> userIdentyJson = new HashMap<String, String>();
            userIdentyJson.put("fullName", userFullName);
            jsonObject.put("locker", userIdentyJson);
        } else if (validateContent && (context = this._renderingContextHandler.getRenderingContext()) == RenderingContext.FRONT && content instanceof VersionableAmetysObject && !Arrays.asList(labels = ((VersionableAmetysObject)content).getLabels()).contains("Live")) {
            success = false;
            jsonObject.put("error", "draft");
        }
        if (success) {
            if (workflowIdsAsString == null) {
                success = false;
                jsonObject.put("error", "no workflow Ids");
                request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
                return EMPTY_MAP;
            }
            List<String> workflowIdsAsStrings = Arrays.asList(workflowIdsAsString.split(";"));
            ArrayList<Integer> workflowIds = new ArrayList<Integer>();
            for (String workflowIdAsString : workflowIdsAsStrings) {
                workflowIds.add(Integer.parseInt(workflowIdAsString));
            }
            boolean workflowRightsOk = AmetysFrontEditionHelper.hasWorkflowRight(workflowIds, contentId, false);
            if (!workflowRightsOk) {
                success = false;
                jsonObject.put("error", "workflow-rights");
                request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
                return EMPTY_MAP;
            }
        }
        if (success) {
            ArrayList<String> contentIds = new ArrayList<String>(1);
            contentIds.add(contentId);
            this._lockContentManager.unlockOrLock(contentIds, "lock");
            List<String> languages = this.getLanguages(request);
            HashMap<String, Map<String, Object>> attributeJsonObject = new HashMap<String, Map<String, Object>>();
            for (String attributePath : attributePaths) {
                ModelItem modelItem = this.getDefinition(content, attributePath);
                if (!this.checkRestriction(content, modelItem)) continue;
                Map<String, Object> contentAttribute2Json = this._contentAttribute2Json(content, modelItem, attributePath, languages);
                attributeJsonObject.put(attributePath, contentAttribute2Json);
            }
            jsonObject.put("data", attributeJsonObject);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, jsonObject);
        return EMPTY_MAP;
    }

    protected boolean checkRestriction(Content content, ModelItem modelItem) {
        if (modelItem instanceof RestrictedModelItem) {
            return ((RestrictedModelItem)modelItem).canWrite((Object)content);
        }
        return true;
    }

    protected UserIdentity isContentLocked(Content content) {
        if (!(content instanceof JCRAmetysObject)) {
            return null;
        }
        try {
            LockableAmetysObject lockableAO;
            Node lockHolder;
            AmetysObject ao;
            Node node = ((JCRAmetysObject)content).getNode();
            LockManager lockManager = node.getSession().getWorkspace().getLockManager();
            if (lockManager.isLocked(node.getPath()) && (ao = this._resolver.resolve(lockHolder = lockManager.getLock(node.getPath()).getNode(), false)) instanceof LockableAmetysObject && !LockHelper.isLockOwner((LockAwareAmetysObject)(lockableAO = (LockableAmetysObject)ao), (UserIdentity)this._currentUserProvider.getUser())) {
                return lockableAO.getLockOwner();
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error(String.format("Repository exception during lock checking for ametys object '%s'", content.getId()), (Throwable)e);
            throw new AmetysRepositoryException((Throwable)e);
        }
        return null;
    }

    protected List<String> getLanguages(Request request) {
        Enumeration locales = request.getLocales();
        ArrayList<String> languages = new ArrayList<String>();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            String lang = locale.getLanguage();
            if (languages.contains(lang)) continue;
            languages.add(lang);
        }
        return languages;
    }

    protected ModelItem getDefinition(Content content, String attributePath) throws ProcessingException, AmetysRepositoryException {
        if (!content.hasDefinition(attributePath)) {
            throw new ProcessingException(String.format("Unknown attribute path '%s' for content type(s) '%s'", attributePath, StringUtils.join((Object[])content.getTypes(), (char)',')));
        }
        return content.getDefinition(attributePath);
    }

    protected Map<String, Object> _contentAttribute2Json(Content content, ModelItem modelItem, String attributePath, List<String> languages) throws ProcessingException {
        Object value;
        Map jsonObject = modelItem.toJSON(DefinitionContext.newInstance().withObject((Object)content));
        String help = this._getModelItemHelpLink(modelItem, languages);
        if (StringUtils.isNotBlank((CharSequence)help)) {
            jsonObject.put("help", help);
        }
        if (modelItem instanceof ElementDefinition && (!(modelItem instanceof RestrictedModelItem) || ((RestrictedModelItem)modelItem).canRead((Object)content)) && (value = content.getValue(attributePath)) != null) {
            DataContext context;
            ElementType type = (ElementType)modelItem.getType();
            Object valueAsJSON = type.valueToJSONForEdition(value, context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)content).withDataPath(attributePath).withModelItem(modelItem));
            if (valueAsJSON instanceof List) {
                if (!((List)valueAsJSON).isEmpty()) {
                    Object[] arrayValue = (Object[])Array.newInstance(((List)valueAsJSON).get(0).getClass(), ((List)valueAsJSON).size());
                    jsonObject.put("value", ((List)valueAsJSON).toArray(arrayValue));
                } else {
                    jsonObject.put("value", new Object[0]);
                }
            } else {
                jsonObject.put("value", valueAsJSON);
            }
        }
        return jsonObject;
    }

    protected String _getModelItemHelpLink(ModelItem modelItem, List<String> languages) {
        Model model = modelItem.getModel();
        if (model != null) {
            String modelId = model.getId();
            String family = model.getFamilyId();
            String path = modelItem.getPath();
            if (StringUtils.isNotBlank((CharSequence)path)) {
                path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            }
            String featureId = StringUtils.join((Object[])new String[]{modelId, path});
            featureId = StringUtils.removeStart((String)featureId, (String)"/");
            try {
                return this._helpManager.getHelp(family, featureId, languages);
            }
            catch (Exception e) {
                this._logger.warn("Impossible to get help for the content type '{}' on path '{}'", new Object[]{modelId, path, e});
            }
        }
        return "";
    }
}

