/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class handle the message bus. A message is a way for ui elements to communicate without knwoing each others.
 * One tool will say "I just edit the content X", a concerned button will then refresh. But both elements does not references themselves. 
 * 
 * Use this class to register/unregister your component or to send a message.
 */
Ext.define("Ametys.message.MessageBus",
    {
        singleton: true,
        
        /**
         * @property {Object} _listeners The registered listeners. An association of event type and functions.
         * @property {Object[]} _listeners.MESSAGETYPE The event type list of listeners
         * @property {Function} _listeners.MESSAGETYPE.fn The function to call
         * @property {Object} _listeners.MESSAGETYPE.scope The scope to use
         * @private
         */
        _listeners: {},
        
        /**
         * @property {Ametys.message.Message} _currentSelectionMessage The current selection
         * @private
         */
        /**
         * @property {Ametys.message.Message} _currentSelectionChangingMessage The current changing selection
         * @private
         */
        
        /**
         * This method adds an function to the registered list of message receivers for a given event type.
         * You must unregister the object before you destroy it. See {@link #un}
         * @param {String} messageType See Ametys.message.Message#cfg-type. Use '*' to register to all messages. Cannot be null.
         * @param {Function} listener The function to call. The function has the following signature:
         * @param {Ametys.message.Message} listener.message The message received
         * @param {Object} scope The scope used to call this function
         */
        on: function(messageType, listener, scope)
        {
            // Nothing
        },

        /**
         * This method removes an object to the registered list of message receivers.
         * @param {String} messageType See Ametys.message.Message#cfg-type
         * @param {Function} listener The function to call
         * @param {Object} scope The scope used to call this function
         */
        un: function(messageType, listener, scope)
        {
            // Nothing
        },
        
        /**
         * This method removes an object to the all registered list of message receivers.
         * @param {Object} scope The scope used to call this function
         */
        unAll: function (scope)
        {
            // Nothing
        },
        
        /**
         * Get the current selection.
         * @returns {Ametys.message.Message} The last message of type Ametys.message.Message#SELECTION_CHANGED. Cannot be null, be can contains empty targets.
         */
        getCurrentSelectionMessage: function()
        {
            return null;
        },
        
        /**
         * @private
         * Main method of the bus : send a serie of message to the registered objects.
         * @param {Ametys.message.Message} message An array of message to send.
          */
        fire: function(message)
        {
            // Nothing
        },
        
        /**
         * @private
         * This will log the different listeners size. For debug purposes.
         */
        debugListenersSize: function()
        {
            // Nothing
        }
    }
);
