/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 Ext.define("Ametys.cms.form.widget.SelectContent.ContentEntry", {
    extend: 'Ext.data.Model',
    
    fields: [
        { name: 'id'},
        {
            name: 'title', 
            type: 'string', 
            convert: function(value, record)
            {
                if (Ext.isObject(value))
                {
                    // Handle multilingual title
                    if (value[AmetysFrontEdition.LANG])
                    {
                        return value[AmetysFrontEdition.LANG];
                    }
                    else if (value.en)
                    {
                        return value.en;
                    }
                    else
                    {
                        // return the first non-empty value
                        var value = '';
                        Ext.Object.eachValue(values, function(v) {
                            if (Ext.isEmpty(v))
                            {
                                value = v;
                                return false; // stop iteration
                            }
                        });
                        
                        return value;
                    }
                }
                else
                {
                    return value;
                }
            }
         },
        { name: 'iconGlyph', convert: function(v) { return v || ''; }},
        { name: 'iconDecorator', convert: function(v) { return v || ''; }},
        { name: 'smallIcon', convert: function(v) { return v || ''; }},
        { name: 'mediumIcon', convert: function(v) { return v || ''; }},
        { name: 'largeIcon', convert: function(v) { return v || ''; }},
        { name: 'contentTypes' },
        { name: 'mixins' },
        { name: 'clickable', type: 'boolean', defaultValue: true},
        { name: 'archived', type: 'boolean', defaultValue: false}
    ]
});