/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

(function (){
Ext.override(Ametys.cms.uihelper.ChooseAttachmentFile, {
    _checkUserRight: function (node)
    {
        var createLink = this._box.child("component[cls~=link]");
        
        var content = AmetysFrontEdition.modifiableContents[this.ownerId];
        if (content != null && content.rights.hasAddFileRight)
        {
            createLink.update("<a class='action'>{{i18n plugin.cms:PLUGINS_CMS_HELPER_CHOOSEATTACHMENTSFILE_UPLOAD_FILE}}</a>");
            // add a click event listener on the <a class='action'> dom node to call the #insertAttachment method.
            if (!this._clickEventRegistered)
            {
                createLink.mon(createLink.getEl(), 'click', Ext.bind(this.insertAttachment, this), this, {delegate: 'a.action'});
                this._clickEventRegistered = true;
            }
        }
        else
        {
            // No right to insert file
            this._clickEventRegistered = false;
            createLink.update("{{i18n plugin.cms:PLUGINS_CMS_HELPER_CHOOSEATTACHMENTSFILE_UPLOAD_FILE_NORIGHT}}");
        }
    }
});
})();
