/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
(function (){
Ext.override(Ametys.data.ServerComm, {
        _lastTime: 0,
    
        _ask: function(message)
        {
            return true;
        },
        
        send: function(message)
        {
            var ret = this.callParent(arguments);

            if (Ametys.isSuspended() && message.priority != Ametys.data.ServerComm.PRIORITY_MINOR && this._lastTime < new Date().getTime() - 10000)
            {
                this._lastTime = new Date().getTime();
                alert("{{i18n plugin.core-ui:PLUGINS_CORE_UI_SERVERCOMM_LISTENERREQUEST_SERVERUNAVAILABLE_TITLE}}\n\n{{i18n plugin.core-ui:PLUGINS_CORE_UI_SERVERCOMM_LISTENERREQUEST_SERVERUNAVAILABLE_MESSAGE}}".replace(/<br\/>/g, '\n'))
            }

            return ret;
        }        
});
})();
