/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
(function (){
Ext.override(Ametys.form.widget.Image, {
    
    constructor: function (config)
    {
        if (config.autoClick === undefined)
        {
            config.autoClick = true;
        }
        
        config.uploadUrl = AmetysFrontEdition.CONTEXT_PATH + "/_plugins/front-edition/upload/store";
        config.cropUrl = {
            plugin: 'front-edition',
            url: 'upload/crop-and-store'
        }
        config.allowDragAndDrop = false;
        
        this.callParent(arguments);
    },
    
    _insertResourceCb: function(id, filename, fileSize, viewHref, downloadHref, type)
    {
        this.callParent(arguments);

        if (id != null)
        {
            if (this.autoClick)
            {
                AmetysFrontEdition.closeEdition(true);
            }
        }
        else
        {
            if (this._usedAutoClick) // When file upload will call the callback event on cancel (not working at the moment)
            {
                AmetysFrontEdition.closeEdition(false);
            }
        }
    },
    
    _effectiveDeletFile: function(btn)
    {
        this.callParent(arguments);

        if (this.autoClick && btn == 'yes')
        {
            AmetysFrontEdition.closeEdition(true);
        }
    }
});
})();