/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

(function (){
    Ext.override(Ametys.window.DialogBox, {
    
        constructor: function(config)
        {
            var isMobile = screen.width < 768 || screen.height < 768;
            
            if (isMobile)
            {
                config.minWidth = null;
                config.maxWidth = null;
                config.width = "100%";
                config.minHeight = null;
                config.maxHeight = null;
                config.height = "100%";
                config.freezeHeight = false;
                config.draggable = false;
                
                if (config.buttons)
                {
                    config.dockedItems = Ext.Array.from(config.dockedItems);
                    config.dockedItems.push({
                        xtype: 'toolbar',
                        dock: 'bottom',
                        ui: 'footer',
                        overflowHandler: 'scroller',
                        items: Ext.Array.push([], { xtype: 'component', flex: 1 }, Ext.Array.from(config.buttons))
                    });
                    config.buttons = undefined;
                }
            }
            
            this.callParent(arguments);
            
            if (isMobile)
            {
                Ext.on('resize', this._onWindowResize, this);
            }
        },
        
        _onWindowResize: function()
        {
            if (this.rendered)
            {
                this.updateLayout(); // Reapply the 100% compute
            }
        }
    });
})();
