/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * This is a mock DAO to manage current user preferences, but do nothing.
 */
Ext.define('Ametys.userprefs.UserPrefsDAO', {
	singleton: true,
	
	/**
	 * @property {String} [_defaultPrefContext="/runtime"] The default context
	 * @private
	 */
	_defaultPrefContext: '/runtime',
	
	/**
	 * Change the pref context
	 */
	setDefaultPrefContext: function(context)
	{
		this._defaultPrefContext = context;
	},
	
	/**
	 * Get the default pref context
	 * @return {String} the default pref context
	 */
	getDefaultPrefContext: function ()
	{
		return this._defaultPrefContext;
	},
	
	/**
	 * This method reset the local cache (so future reading of preferences will do a server connection)
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 */
	resetCache: function(prefContext)
	{
		// Nothing
	},
	
	/**
	 * Replace the cache with the given object
	 * @param {Object} cache The cache of user prefs values. The key is the user pref identifier and the value is the array of associated values
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 */
	preload: function(cache, prefContext)
	{
		// Nothing
	},
	
	/**
	 * This method is preloading several preferences in the local cache.
	 * @param {Function} callback A callback function that will be called when prepareCache is done.
	 * @param {Boolean} callback.success True if the load was successful
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 */
	load: function(callback, prefContext)
	{
		callback(true);
        return;
	},

	/**
	 * Build an array with all know cache keys
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 * @return {String[]} Known keys. Can be null if cache is empty.
	 */
	keys: function(prefContext)
	{
        return null;
	},
	
	/**
	 * This method reads a preference.
	 * @param {String} preference The preference name to load. Cannot be null or empty.
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 * @return {Object} The value of the preference. Can be null if cache is empty.
	 */
	getValue: function(preference, prefContext)
	{
		return null;
	},
	
	/**
	 * This method reads a preference.
	 * @param {String} preference The preference name to load. Cannot be null or empty.
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 * @return {Object[]} The values of the preference. Can be null if cache is empty.
	 */
	getValues: function(preference, prefContext)
	{
		return null;
	},


	/**
	 * Change the values
	 * @param {Object} params User prefs: key and values
	 * @param {Function} callback A callback when finished
	 * @param {Boolean} callback.success Has the save operation been successful?
	 * @param {Object} [callback.errors] The key is the preference name, and the value an error message. Can be empty event is success is false on server exception: in that cas the user is already notified. 
	 * @param {String} [prefContext] The pref context to use. Switch to default context if missing. See #setDefaultPrefContext.
	 * @param {Number} [priority] The priority of the Ametys.data.ServerComm#send call: default is Ametys.data.ServerComm#PRIORITY_MAJOR. Set to Ametys.data.ServerComm#PRIORITY_MINOR to save less important preferences. 
	 * @param {String} [cancelCode] A cancel code to prevent many successive save process. See Ametys.data.ServerComm#send for more information.
	 * @param {String} [plugin] The name of the plugin targeted for the server request. See Ametys.data.ServerComm#send for more information.
	 * @param {String} [url] The url on the server relative to the plugin. See Ametys.data.ServerComm#send for more information.
	 */
	saveValues: function(params, callback, prefContext, priority, cancelCode, plugin, url)
	{
        callback(true);
	}
});
