/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.hyperplanning;

import com.indexeducation.hyperplanning.ApiClient;
import com.indexeducation.hyperplanning.ApiException;
import com.indexeducation.hyperplanning.api.CoursAnnulesApi;
import com.indexeducation.hyperplanning.api.CoursApi;
import com.indexeducation.hyperplanning.api.EtudiantsApi;
import com.indexeducation.hyperplanning.api.IcalsApi;
import com.indexeducation.hyperplanning.api.MatieresApi;
import com.indexeducation.hyperplanning.model.Cours;
import com.indexeducation.hyperplanning.model.CoursAnnules;
import com.indexeducation.hyperplanning.model.CoursAnnulesCleDetailSeancesPlaceesGet200ResponseInner;
import com.indexeducation.hyperplanning.model.Etudiants;
import com.indexeducation.hyperplanning.model.Matieres;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.HttpUtils;
import org.ametys.plugins.hyperplanning.UnknownStudentException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class HyperplanningManager
extends AbstractLogEnabled
implements Initializable,
Component,
Serviceable {
    public static final String ROLE = HyperplanningManager.class.getName();
    private static final String __CANCELLED_LESSONS_CACHE = HyperplanningManager.class.getName() + "$cancelledLessons";
    private static final String __STUDENT_ICAL_CACHE = HyperplanningManager.class.getName() + "$studentsIcals";
    private static final String __CAS_IDENTIFIER_CACHE = HyperplanningManager.class.getName() + "$casIdentifiers";
    private static final List<String> __COURS_ANNULES_SELECT = List.of("cle", "matiere", "commentaire", "motif_annulation", "date_heure_annulation");
    private String _connectionLogin;
    private String _connectionPass;
    private String _serverUrl;
    private IcalsApi _icalApi;
    private CoursApi _coursApi;
    private CoursAnnulesApi _coursAnnulesApi;
    private EtudiantsApi _etudiantsApi;
    private MatieresApi _matiereApi;
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._connectionLogin = (String)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.login");
        this._connectionPass = (String)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.password");
        this._serverUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.url")));
        this._cacheManager.createMemoryCache(__CANCELLED_LESSONS_CACHE, new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_CANCELLED_LESSONS_CACHE_LABEL"), new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_CANCELLED_LESSONS_CACHE_DESCRIPTION"), true, Duration.ofMinutes((Long)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.cache-validity")));
        this._cacheManager.createMemoryCache(__STUDENT_ICAL_CACHE, new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_STUDENT_ICALS_CACHE_LABEL"), new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_STUDENT_ICALS_CACHE_DESCRIPTION"), true, Duration.ofMinutes((Long)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.cache-validity")));
        this._cacheManager.createMemoryCache(__CAS_IDENTIFIER_CACHE, new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_CAS_IDENTIFIER_CACHE_LABEL"), new I18nizableText("plugin.hyperplanning", "PLUGIN_HYPERPLANNING_CAS_IDENTIFIER_CACHE_DESCRIPTION"), true, Duration.ofMinutes((Long)Config.getInstance().getValue("org.ametys.plugins.hyperplanning.cache-validity")));
        this._initializeWebService();
    }

    public String getStudentIcal(UserIdentity userIdentity) {
        Cache cache = this._cacheManager.get(__STUDENT_ICAL_CACHE);
        return (String)cache.get((Object)userIdentity, this::_getStudentIcal);
    }

    protected String _getStudentIcal(UserIdentity userIdentity) {
        try {
            Optional<String> etudiantCle = this.getEtudiantCle(userIdentity);
            if (etudiantCle.isEmpty()) {
                return null;
            }
            return this._icalApi.icalEtudiantsClePost(etudiantCle.get(), null).getIcal();
        }
        catch (ApiException e) {
            this.getLogger().error("Failed to retrieve Ical for user", (Throwable)e);
            return null;
        }
    }

    public Set<CancelledLesson> getUpcomingCancelledLessons(UserIdentity userIdentity) throws UnknownStudentException {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User is not connected");
        }
        Set cancelledLessons = (Set)this.getCancelledLessonsCache().get((Object)userIdentity, this::_getCancelledLessons);
        if (cancelledLessons == null) {
            throw new UnknownStudentException("User '" + String.valueOf(userIdentity) + "' has no link hyperplanning id");
        }
        return cancelledLessons;
    }

    private Set<CancelledLesson> _getCancelledLessons(UserIdentity userIdentity) {
        try {
            Optional<String> hypIdentity = this.getEtudiantCle(userIdentity);
            if (hypIdentity.isEmpty()) {
                return null;
            }
            ZonedDateTime startDate = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
            ZonedDateTime endDate = startDate.plusWeeks(2L).plusDays(1L);
            List coursAnnules = this._coursAnnulesApi.coursAnnulesGet(null, __COURS_ANNULES_SELECT, null, null, null, null, startDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), endDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), null, null, null, null, null, List.of(hypIdentity.get()));
            Comparator comparator = (c1, c2) -> c1.date().compareTo(c2.date());
            TreeSet<CancelledLesson> result = new TreeSet<CancelledLesson>(comparator);
            for (CoursAnnules cours : coursAnnules) {
                String motifAnnulation = cours.getMotifAnnulation();
                Integer cleMatiere = cours.getMatiere();
                Matieres matiere = this._matiereApi.matieresCleGet(cleMatiere.toString());
                List seances = this._coursAnnulesApi.coursAnnulesCleDetailSeancesPlaceesGet(cours.getCle());
                for (CoursAnnulesCleDetailSeancesPlaceesGet200ResponseInner seance : seances) {
                    ZonedDateTime dateSeance = LocalDateTime.parse(seance.getJourHeureDebut()).atZone(ZoneId.systemDefault());
                    if (!dateSeance.isAfter(startDate) || !dateSeance.isBefore(endDate)) continue;
                    result.add(new CancelledLesson(matiere.getCode(), matiere.getLibelle(), matiere.getLibelleLong(), dateSeance, motifAnnulation, cours.getCommentaire()));
                }
            }
            return result;
        }
        catch (ApiException e) {
            this.getLogger().error("An error occured while contacting Hyperplanning", (Throwable)e);
            return null;
        }
    }

    public Map<CancelledLesson, List<String>> getCancelledLessons(LocalDateTime cancellationMinDate, LocalDateTime lessonMinDate, LocalDateTime lessonMaxDate) {
        Predicate<CoursAnnules> cancellationMinDatePredicate = this._getCancellationDateFilter(cancellationMinDate);
        HashMap<CancelledLesson, List<String>> result = new HashMap<CancelledLesson, List<String>>();
        try {
            String minDate = lessonMinDate != null ? lessonMinDate.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME) : null;
            String maxDate = lessonMaxDate != null ? lessonMaxDate.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME) : null;
            List coursAnnules = this._coursAnnulesApi.coursAnnulesGet(null, __COURS_ANNULES_SELECT, null, null, null, null, minDate, maxDate, null, null, null, null, null, null);
            block2: for (CoursAnnules coursAnnule : coursAnnules) {
                if (!cancellationMinDatePredicate.test(coursAnnule)) continue;
                Matieres matiere = this._matiereApi.matieresCleGet(coursAnnule.getMatiere().toString());
                Cours cours = null;
                List seances = this._coursAnnulesApi.coursAnnulesCleDetailSeancesPlaceesGet(coursAnnule.getCle());
                for (CoursAnnulesCleDetailSeancesPlaceesGet200ResponseInner seance : seances) {
                    LocalDateTime dateSeance = LocalDateTime.parse(seance.getJourHeureDebut(), DateTimeFormatter.ISO_DATE_TIME);
                    if (lessonMinDate != null && !dateSeance.isAfter(lessonMinDate) || lessonMaxDate != null && !dateSeance.isBefore(lessonMaxDate)) continue;
                    if (cours == null) {
                        Integer cleCours = seance.getCleCours();
                        if (cleCours == 0) continue block2;
                        cours = this._coursApi.coursCleGet(cleCours.toString());
                    }
                    List<String> casIdentifiers = this._getCASIdentifiers(cours.getEtudiants());
                    CancelledLesson cancelledLesson = new CancelledLesson(matiere.getCode(), matiere.getLibelle(), matiere.getLibelleLong(), dateSeance.atZone(ZoneId.systemDefault()), coursAnnule.getMotifAnnulation(), coursAnnule.getCommentaire());
                    result.put(cancelledLesson, casIdentifiers);
                }
            }
        }
        catch (ApiException e) {
            this.getLogger().error("Failed to compute notification of cancelled course", (Throwable)e);
        }
        return result;
    }

    private List<String> _getCASIdentifiers(List<Integer> etudiant) {
        Cache cache = this._cacheManager.get(__CAS_IDENTIFIER_CACHE);
        return etudiant.stream().map(cle -> (String)cache.get((Object)cle.toString(), c -> {
            try {
                return this._etudiantsApi.etudiantsCleGet(c).getCasIdentifiant();
            }
            catch (ApiException e) {
                this.getLogger().error("Failed to fetch CAS identifiant for student key: " + c);
                return null;
            }
        })).filter(Objects::nonNull).toList();
    }

    private Predicate<CoursAnnules> _getCancellationDateFilter(LocalDateTime cancellationMinDate) {
        return cancellationMinDate != null ? c -> LocalDateTime.parse(c.getDateHeureAnnulation(), DateTimeFormatter.ISO_DATE_TIME).isAfter(cancellationMinDate) : c -> true;
    }

    protected Optional<String> getEtudiantCle(UserIdentity userIdentity) throws ApiException {
        List etudiants = this._etudiantsApi.etudiantsGet(null, List.of("cle"), null, null, null, null, null, null, null, List.of(userIdentity.getLogin()), null, null);
        if (etudiants.isEmpty()) {
            this.getLogger().debug("No matching hyperplanning student for CAS login: " + userIdentity.getLogin());
            return Optional.empty();
        }
        if (etudiants.size() > 1) {
            this.getLogger().info("Multiple hyperplanning student for CAS login: " + userIdentity.getLogin());
            return Optional.empty();
        }
        return Optional.of(((Etudiants)etudiants.get(0)).getCle().toString());
    }

    private void _initializeWebService() {
        ApiClient client = new ApiClient();
        client.setBasePath(this._serverUrl + "/hpsw/api/v1");
        client.setUsername(this._connectionLogin);
        client.setPassword(this._connectionPass);
        this._matiereApi = new MatieresApi(client);
        this._coursApi = new CoursApi(client);
        this._coursAnnulesApi = new CoursAnnulesApi(client);
        this._etudiantsApi = new EtudiantsApi(client);
        this._icalApi = new IcalsApi(client);
    }

    private Cache<UserIdentity, Set<CancelledLesson>> getCancelledLessonsCache() {
        return this._cacheManager.get(__CANCELLED_LESSONS_CACHE);
    }

    public record CancelledLesson(String code, String label, String fullLabel, ZonedDateTime date, String cancelRationale, String cancelComment) {
    }
}

