/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.cms.data.Binary;
import org.ametys.cms.tag.Tag;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProviderExtensionPoint;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.linkdirectory.theme.ThemeExpression;
import org.ametys.plugins.linkdirectory.theme.ThemesDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinConfigurationHelper;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.util.ISO9075;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DirectoryHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = DirectoryHelper.class.getName();
    private static final String __CONF_FILE_PATH = "conf/link-directory.xml";
    private static final String __PLUGIN_NODE_NAME = "linkdirectory";
    private static final String __LINKS_NODE_NAME = "ametys:directoryLinks";
    private static final String __USER_LINKS_NODE_NAME = "user-favorites";
    protected ThemesDAO _themesDAO;
    private AmetysObjectResolver _ametysObjectResolver;
    private SiteManager _siteManager;
    private UserPreferencesManager _userPreferencesManager;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;
    private LinkDAO _linkDAO;
    private Context _context;
    private DynamicInformationProviderExtensionPoint _dynamicProviderEP;
    private SkinsManager _skinsManager;
    private SkinConfigurationHelper _skinConfigurationHelper;
    private ServiceManager _smanager;

    public void service(ServiceManager manager) throws ServiceException {
        this._smanager = manager;
        this._ametysObjectResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._userPreferencesManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._dynamicProviderEP = (DynamicInformationProviderExtensionPoint)((Object)manager.lookup(DynamicInformationProviderExtensionPoint.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._linkDAO = (LinkDAO)((Object)manager.lookup(LinkDAO.ROLE));
        this._themesDAO = (ThemesDAO)((Object)manager.lookup(ThemesDAO.ROLE));
    }

    private SkinsManager _getSkinManager() {
        if (this._skinsManager == null) {
            try {
                this._skinsManager = (SkinsManager)this._smanager.lookup(SkinsManager.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this._skinsManager;
    }

    private SkinConfigurationHelper _getSkinConfigurationHelper() {
        if (this._skinConfigurationHelper == null) {
            try {
                this._skinConfigurationHelper = (SkinConfigurationHelper)this._smanager.lookup(SkinConfigurationHelper.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this._skinConfigurationHelper;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public ModifiableTraversableAmetysObject getPluginNode(Site site) throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginsNode = site.getRootPlugins();
            return this.getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the link directory plugin node for site " + site.getName(), (Throwable)e);
        }
    }

    public ModifiableTraversableAmetysObject getLinksNode(Site site, String language) throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginNode = this.getPluginNode(site);
            ModifiableTraversableAmetysObject langNode = this.getOrCreateNode(pluginNode, language, "ametys:unstructured");
            return this.getOrCreateNode(langNode, __LINKS_NODE_NAME, __LINKS_NODE_NAME);
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the link directory root node for site " + site.getName() + " and language " + language, (Throwable)e);
        }
    }

    public ModifiableTraversableAmetysObject getLinksForUserNode(Site site, String language, UserIdentity user) throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginNode = this.getPluginNode(site);
            ModifiableTraversableAmetysObject userLinksNode = this.getOrCreateNode(pluginNode, __USER_LINKS_NODE_NAME, "ametys:unstructured");
            ModifiableTraversableAmetysObject populationNode = this.getOrCreateNode(userLinksNode, user.getPopulationId(), "ametys:unstructured");
            ModifiableTraversableAmetysObject loginNode = this.getOrCreateNode(populationNode, user.getLogin(), "ametys:unstructured");
            ModifiableTraversableAmetysObject langNode = this.getOrCreateNode(loginNode, language, "ametys:unstructured");
            return this.getOrCreateNode(langNode, __LINKS_NODE_NAME, __LINKS_NODE_NAME);
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the link directory root node for user " + String.valueOf(user) + " and for site " + site.getName() + " and language " + language, (Throwable)e);
        }
    }

    public String getPluginNodePath(String siteName) {
        return String.format("//element(%s, ametys:site)/ametys-internal:plugins/%s", siteName, __PLUGIN_NODE_NAME);
    }

    public String getLinksNodePath(String siteName, String language) {
        return this.getPluginNodePath(siteName) + "/" + language + "/ametys:directoryLinks";
    }

    public String getLinksForUserNodePath(String siteName, String language, UserIdentity user) {
        return this.getPluginNodePath(siteName) + "/user-favorites/" + ISO9075.encode((String)user.getPopulationId()) + "/" + ISO9075.encode((String)user.getLogin()) + "/" + language + "/ametys:directoryLinks";
    }

    public String getAllLinksQuery(String siteName, String language) {
        return this.getLinksNodePath(siteName, language) + "/element(*, ametys:directoryLink)";
    }

    public String getLinksQuery(String siteName, String language, Expression expression) {
        return this.getLinksNodePath(siteName, language) + "/element(*, ametys:directoryLink)[" + expression.build() + "]";
    }

    public String getUserLinksQuery(String siteName, String language, UserIdentity user, Expression expression) {
        String query = this.getLinksForUserNodePath(siteName, language, user) + "/element(*, ametys:directoryLink)";
        if (expression != null) {
            query = query + "[" + expression.build() + "]";
        }
        return query;
    }

    public String getUrlExistsQuery(String siteName, String language, String url) {
        String lowerCaseUrl = StringUtils.replace((String)url, (String)"'", (String)"''").toLowerCase();
        return this.getLinksNodePath(siteName, language) + "/element(*, ametys:directoryLink)[fn:lower-case(@ametys-internal:url) = '" + lowerCaseUrl + "' or fn:lower-case(@ametys-internal:internal-url) = '" + lowerCaseUrl + "']";
    }

    public String getUrlExistsForUserQuery(String siteName, String language, String url, UserIdentity user) {
        String lowerCaseUrl = StringUtils.replace((String)url, (String)"'", (String)"''").toLowerCase();
        return this.getLinksForUserNodePath(siteName, language, user) + "/element(*, ametys:directoryLink)[fn:lower-case(@ametys-internal:url) = '" + lowerCaseUrl + "' or fn:lower-case(@ametys-internal:internal-url) = '" + lowerCaseUrl + "']";
    }

    public String normalizeString(String s) {
        String normalizedLabel = Normalizer.normalize(s.toUpperCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        String upperCaseLabel = normalizedLabel.replaceAll(" +", "_").replaceAll("[^\\w-]", "_").replaceAll("_+", "_").toUpperCase();
        return upperCaseLabel;
    }

    public AmetysObjectIterable<DefaultLink> getLinks(String siteName, String language) {
        Site site = this._siteManager.getSite(siteName);
        ModifiableTraversableAmetysObject linksNode = this.getLinksNode(site, language);
        return linksNode.getChildren();
    }

    public List<DefaultLink> getLinks(List<String> themesIds, String siteName, String language) {
        Site site = this._siteManager.getSite(siteName);
        ModifiableTraversableAmetysObject linksNode = this.getLinksNode(site, language);
        AmetysObjectIterable links = linksNode.getChildren();
        return links.stream().filter(l -> themesIds.isEmpty() || !Collections.disjoint(Arrays.asList(l.getThemes()), themesIds)).collect(Collectors.toList());
    }

    public AmetysObjectIterable<DefaultLink> getUserLinks(String siteName, String language, UserIdentity user) {
        return this.getUserLinks(siteName, language, user, null);
    }

    public AmetysObjectIterable<DefaultLink> getUserLinks(String siteName, String language, UserIdentity user, String themeName) {
        ThemeExpression themeExpression = null;
        if (StringUtils.isNotBlank((CharSequence)themeName) && this.themeExists(themeName, siteName, language)) {
            themeExpression = new ThemeExpression(themeName);
        }
        String linksQuery = this.getUserLinksQuery(siteName, language, user, themeExpression);
        return this._ametysObjectResolver.query(linksQuery);
    }

    public boolean hasRestrictions(String siteName, String language, List<String> themesIds) {
        block14: {
            if (themesIds.isEmpty()) {
                String allLinksQuery = this.getAllLinksQuery(siteName, language);
                try (AmetysObjectIterable links = this._ametysObjectResolver.query(allLinksQuery);){
                    if (this.isAccessRestricted((AmetysObjectIterable<AmetysObject>)links)) {
                        boolean bl = true;
                        return bl;
                    }
                    break block14;
                }
            }
            for (String themeId : themesIds) {
                String xPathQuery = this.getLinksQuery(siteName, language, new ThemeExpression(themeId));
                AmetysObjectIterable links = this._ametysObjectResolver.query(xPathQuery);
                try {
                    if (!this.isAccessRestricted((AmetysObjectIterable<AmetysObject>)links)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (links == null) continue;
                    links.close();
                }
            }
        }
        return false;
    }

    public boolean hasInternalUrl(String siteName, String language, List<String> themesIds) {
        Site site = this._siteManager.getSite(siteName);
        String allowedIdParameter = (String)site.getValue("allowed-ip");
        if (StringUtils.isBlank((CharSequence)allowedIdParameter)) {
            return false;
        }
        List<DefaultLink> links = this.getLinks(themesIds, siteName, language);
        for (DefaultLink link : links) {
            if (!StringUtils.isNotBlank((CharSequence)link.getInternalUrl())) continue;
            return true;
        }
        return false;
    }

    public boolean isAccessRestricted(AmetysObjectIterable<AmetysObject> links) {
        for (DefaultLink link : links) {
            if (this._rightManager.hasAnonymousReadAccess((Object)link)) continue;
            return true;
        }
        return false;
    }

    private ModifiableTraversableAmetysObject getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject node;
        if (parentNode.hasChild(nodeName)) {
            node = (ModifiableTraversableAmetysObject)parentNode.getChild(nodeName);
        } else {
            node = (ModifiableTraversableAmetysObject)parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return node;
    }

    public Configuration getSkinLinksConfiguration(String skinName) throws IOException, ConfigurationException, SAXException {
        Skin skin = this._getSkinManager().getSkin(skinName);
        try (InputStream xslIs = ((Object)((Object)this)).getClass().getResourceAsStream("link-directory-merge.xsl");){
            Configuration configuration = this._getSkinConfigurationHelper().getInheritanceMergedConfiguration(skin, __CONF_FILE_PATH, xslIs);
            return configuration;
        }
    }

    public void saxLinks(String siteName, ContentHandler contentHandler, List<DefaultLink> links, List<DefaultLink> userLinks, List<String> restrictedThemes, boolean isConfigurable, Map<String, String> contextVars, String storageContext, UserIdentity user) throws SAXException, UserPreferencesException {
        ArrayList<Pair<Boolean, DefaultLink>> allLinks = new ArrayList<Pair<Boolean, DefaultLink>>();
        if (links != null) {
            for (DefaultLink link : links) {
                allLinks.add((Pair<Boolean, DefaultLink>)new ImmutablePair((Object)false, (Object)link));
            }
        }
        if (userLinks != null) {
            for (DefaultLink link : userLinks) {
                allLinks.add((Pair<Boolean, DefaultLink>)new ImmutablePair((Object)true, (Object)link));
            }
        }
        Object[] orderedLinksPrefLinksIdsArray = null;
        Object[] hiddenLinksPrefLinksIdsArray = null;
        if (user != null && isConfigurable) {
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, storageContext, contextVars);
            String orderedLinksPrefValues = (String)unTypedUserPrefs.get("checked-links");
            orderedLinksPrefLinksIdsArray = StringUtils.split((String)orderedLinksPrefValues, (String)",");
            String hiddenLinksPrefValues = (String)unTypedUserPrefs.get("hidden-links");
            hiddenLinksPrefLinksIdsArray = StringUtils.split((String)hiddenLinksPrefValues, (String)",");
        }
        Site site = this._siteManager.getSite(siteName);
        boolean hasIPRestriction = this.hasIPRestriction(site);
        boolean isIPAuthorized = this.isInternalIP(site);
        if (ArrayUtils.isNotEmpty(orderedLinksPrefLinksIdsArray)) {
            DefaultLinkSorter defaultLinkSorter = new DefaultLinkSorter(this, allLinks, (String[])orderedLinksPrefLinksIdsArray);
            allLinks.sort(defaultLinkSorter);
        }
        for (Pair pair : allLinks) {
            DefaultLink link = (DefaultLink)pair.getRight();
            boolean userLink = (Boolean)pair.getLeft();
            Link.LinkVisibility defaultVisibility = link.getDefaultVisibility();
            if (!userLink && !this._isCurrentUserGrantedAccess(link)) continue;
            boolean selected = isConfigurable && ArrayUtils.contains((Object[])orderedLinksPrefLinksIdsArray, (Object)link.getId());
            boolean isHidden = isConfigurable && (ArrayUtils.contains((Object[])hiddenLinksPrefLinksIdsArray, (Object)link.getId()) || Link.LinkVisibility.HIDDEN.equals((Object)defaultVisibility) && !selected);
            this.saxLink(siteName, contentHandler, link, restrictedThemes, selected, hasIPRestriction, isIPAuthorized, userLink, isHidden);
        }
    }

    public void saxLink(String siteName, ContentHandler contentHandler, DefaultLink link, List<String> restrictedThemes, boolean selected, boolean hasIPRestriction, boolean isIPAuthorized, boolean userLink, boolean isHidden) throws SAXException {
        String dynInfoProviderId;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", link.getId());
        attrs.addCDATAAttribute("lang", link.getLanguage());
        Link.LinkType urlType = link.getUrlType();
        this._addURLAttribute(link, hasIPRestriction, isIPAuthorized, attrs);
        attrs.addCDATAAttribute("urlType", StringUtils.defaultString((String)urlType.toString()));
        if (link.getStatus() != Link.LinkStatus.BROKEN && StringUtils.isNotEmpty((CharSequence)(dynInfoProviderId = StringUtils.defaultString((String)link.getDynamicInformationProvider()))) && this._dynamicProviderEP.hasExtension(dynInfoProviderId)) {
            attrs.addCDATAAttribute("dynamicInformationProvider", dynInfoProviderId);
        }
        attrs.addCDATAAttribute("title", StringUtils.defaultString((String)link.getTitle()));
        attrs.addCDATAAttribute("content", StringUtils.defaultString((String)link.getContent()));
        if (urlType == Link.LinkType.PAGE) {
            String pageId = link.getUrl();
            try {
                Page page = (Page)this._ametysObjectResolver.resolveById(pageId);
                attrs.addCDATAAttribute("pageTitle", page.getTitle());
            }
            catch (UnknownAmetysObjectException e) {
                attrs.addCDATAAttribute("unknownPage", "true");
            }
        }
        attrs.addCDATAAttribute("alternative", StringUtils.defaultString((String)link.getAlternative()));
        attrs.addCDATAAttribute("pictureAlternative", StringUtils.defaultString((String)link.getPictureAlternative()));
        attrs.addCDATAAttribute("user-selected", selected ? "true" : "false");
        attrs.addCDATAAttribute("color", this._linkDAO.getLinkColor(link));
        String pictureType = link.getPictureType();
        attrs.addCDATAAttribute("pictureType", pictureType);
        if (pictureType.equals("resource")) {
            String resourceId = link.getResourcePictureId();
            try {
                Resource resource = (Resource)this._ametysObjectResolver.resolveById(resourceId);
                attrs.addCDATAAttribute("pictureId", resourceId);
                attrs.addCDATAAttribute("pictureName", resource.getName());
                attrs.addCDATAAttribute("pictureSize", Long.toString(resource.getLength()));
                attrs.addCDATAAttribute("imageType", "explorer");
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().error("The resource of id'{}' does not exist anymore. The picture for link of id '{}' will be ignored.", new Object[]{resourceId, link.getId(), e});
            }
        } else if (pictureType.equals("external")) {
            Binary picMeta = link.getExternalPicture();
            attrs.addCDATAAttribute("picturePath", "picture");
            attrs.addCDATAAttribute("pictureName", picMeta.getFilename());
            attrs.addCDATAAttribute("pictureSize", Long.toString(picMeta.getLength()));
            attrs.addCDATAAttribute("imageType", "link-data");
        } else if (pictureType.equals("glyph")) {
            attrs.addCDATAAttribute("pictureGlyph", link.getPictureGlyph());
        }
        attrs.addCDATAAttribute("limitedAccess", String.valueOf(!this._rightManager.hasAnonymousReadAccess((Object)link)));
        attrs.addCDATAAttribute("userLink", String.valueOf(userLink));
        attrs.addCDATAAttribute("isHidden", String.valueOf(isHidden));
        Link.LinkStatus status = link.getStatus();
        if (status != null) {
            attrs.addCDATAAttribute("status", status.name());
        }
        if (StringUtils.isNotBlank((CharSequence)link.getPage())) {
            attrs.addCDATAAttribute("page", link.getPage());
        }
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"link", (Attributes)attrs);
        this._saxThemes(contentHandler, link, restrictedThemes);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"link");
    }

    private void _addURLAttribute(DefaultLink link, boolean hasIPRestriction, boolean isIPAuthorized, AttributesImpl attrs) {
        String internalUrl = link.getInternalUrl();
        String externalUrl = link.getUrl();
        if (StringUtils.isBlank((CharSequence)internalUrl) || !hasIPRestriction) {
            attrs.addCDATAAttribute("url", StringUtils.defaultString((String)externalUrl));
        } else if (isIPAuthorized) {
            attrs.addCDATAAttribute("url", StringUtils.defaultString((String)internalUrl));
        } else if (StringUtils.isNotBlank((CharSequence)externalUrl)) {
            attrs.addCDATAAttribute("url", StringUtils.defaultString((String)externalUrl));
        } else {
            attrs.addCDATAAttribute("disabled", "true");
        }
    }

    public Map<String, List<String>> getThemesMap(List<String> configuredThemesNames, String siteName, String language) {
        HashMap<String, List<String>> themesMap = new HashMap<String, List<String>>();
        ArrayList<String> correctThemesList = new ArrayList<String>();
        ArrayList<String> wrongThemesList = new ArrayList<String>();
        for (int i = 0; i < configuredThemesNames.size(); ++i) {
            String configuredThemeName = configuredThemesNames.get(i);
            HashMap<String, String> contextualParameters = new HashMap<String, String>();
            contextualParameters.put("language", language);
            contextualParameters.put("siteName", siteName);
            Tag theme = this._themesDAO.getTag(configuredThemeName, contextualParameters);
            if (theme == null) {
                this.getLogger().warn("The theme '{}' was not found. It will be ignored.", (Object)configuredThemeName);
                wrongThemesList.add(configuredThemeName);
                continue;
            }
            correctThemesList.add(configuredThemeName);
        }
        themesMap.put("themes", correctThemesList);
        themesMap.put("unknown-themes", wrongThemesList);
        return themesMap;
    }

    public boolean themeExists(String themeName, String siteName, String language) {
        if (StringUtils.isBlank((CharSequence)themeName)) {
            return false;
        }
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", language);
        contextualParameters.put("siteName", siteName);
        List checkTags = this._themesDAO.checkTags(List.of(themeName), false, Collections.EMPTY_MAP, contextualParameters);
        return !checkTags.isEmpty();
    }

    public I18nizableText getThemeTitle(String themeName, String siteName, String language) {
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", language);
        contextualParameters.put("siteName", siteName);
        if (this.themeExists(themeName, siteName, language)) {
            Tag tag = this._themesDAO.getTag(themeName, contextualParameters);
            return tag.getTitle();
        }
        this.getLogger().warn("Can't find theme with name {} for site {} and language {}", new Object[]{themeName, siteName, language});
        return null;
    }

    public String getSiteName(Request request) {
        return WebHelper.getSiteName((Request)request, (AmetysObject)((Page)request.getAttribute(Page.class.getName())));
    }

    public String getLanguage(Request request) {
        Page page = (Page)request.getAttribute(Page.class.getName());
        if (page != null) {
            return page.getSitemapName();
        }
        String language = (String)request.getAttribute("sitemapLanguage");
        if (StringUtils.isEmpty((CharSequence)language)) {
            language = request.getParameter("language");
        }
        return language;
    }

    public Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", this.getSiteName(request));
        contextVars.put("sitemapLanguage", this.getLanguage(request));
        return contextVars;
    }

    public String getStorageContext(Request request, String zoneItemId) {
        String siteName = this.getSiteName(request);
        String language = this.getLanguage(request);
        return StringUtils.isEmpty((CharSequence)zoneItemId) ? siteName + "/" + language : siteName + "/" + language + "/" + zoneItemId;
    }

    public String getStorageContext(String siteName, String language, String zoneItemId) {
        return StringUtils.isEmpty((CharSequence)zoneItemId) ? siteName + "/" + language : siteName + "/" + language + "/" + zoneItemId;
    }

    private void _saxThemes(ContentHandler contentHandler, DefaultLink link, List<String> restrictedThemes) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"themes");
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", link.getLanguage());
        contextualParameters.put("siteName", link.getSiteName());
        for (String themeId : link.getThemes()) {
            try {
                Tag tag = this._themesDAO.getTag(themeId, contextualParameters);
                if (tag != null) {
                    if (!restrictedThemes.isEmpty() && !restrictedThemes.contains(themeId)) continue;
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("id", themeId);
                    attrs.addCDATAAttribute("name", tag.getName());
                    XMLUtils.startElement((ContentHandler)contentHandler, (String)"theme", (Attributes)attrs);
                    tag.getTitle().toSAX(contentHandler, "label");
                    XMLUtils.endElement((ContentHandler)contentHandler, (String)"theme");
                    continue;
                }
                this.getLogger().error("Theme '{}' in link '{}' can not be found.", (Object)themeId, (Object)link.getId());
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                // empty catch block
            }
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"themes");
    }

    private boolean _isCurrentUserGrantedAccess(DefaultLink link) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this._rightManager.hasReadAccess(user, (Object)link);
    }

    public boolean hasIPRestriction(Site site) {
        return site.getValue("allowed-ip") != null;
    }

    public boolean isInternalIP(Site site) {
        String ipRegexp = (String)site.getValue("allowed-ip");
        if (StringUtils.isNotBlank((CharSequence)ipRegexp)) {
            Pattern ipRestriction = Pattern.compile(ipRegexp);
            Request request = ContextHelper.getRequest((Context)this._context);
            String xff = request.getHeader("X-Forwarded-For");
            String ip = null;
            ip = xff != null ? xff.split(",")[0] : request.getRemoteAddr();
            boolean internalIP = ipRestriction.matcher(ip).matches();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ip '{}' is considered {} with pattern {}", new Object[]{ip, internalIP ? "internal" : "external", ipRestriction.pattern()});
            }
            return internalIP;
        }
        return true;
    }

    private class DefaultLinkSorter
    implements Comparator<Pair<Boolean, DefaultLink>> {
        private String[] _orderedLinksPrefLinksIdsArray;
        private List<String> _initialList;

        public DefaultLinkSorter(DirectoryHelper directoryHelper, List<Pair<Boolean, DefaultLink>> initialList, String[] orderedLinksPrefLinksIdsArray) {
            this._orderedLinksPrefLinksIdsArray = orderedLinksPrefLinksIdsArray;
            this._initialList = initialList.stream().map(Pair::getRight).map(SimpleAmetysObject::getId).collect(Collectors.toList());
        }

        @Override
        public int compare(Pair<Boolean, DefaultLink> pair1, Pair<Boolean, DefaultLink> pair2) {
            DefaultLink link1 = (DefaultLink)pair1.getRight();
            DefaultLink link2 = (DefaultLink)pair2.getRight();
            if (ArrayUtils.isNotEmpty((Object[])this._orderedLinksPrefLinksIdsArray)) {
                int pos2;
                int nbOrderedLinks = this._orderedLinksPrefLinksIdsArray.length;
                int pos1 = ArrayUtils.indexOf((Object[])this._orderedLinksPrefLinksIdsArray, (Object)link1.getId());
                if (pos1 == -1) {
                    pos1 = nbOrderedLinks + this._initialList.indexOf(link1.getId());
                }
                if ((pos2 = ArrayUtils.indexOf((Object[])this._orderedLinksPrefLinksIdsArray, (Object)link2.getId())) == -1) {
                    pos2 = nbOrderedLinks + this._initialList.indexOf(link1.getId());
                }
                return pos1 - pos2;
            }
            return 0;
        }
    }
}

