/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.inputdata.InputData;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LinkDirectoryInputData
extends AbstractLogEnabled
implements Contextualizable,
InputData,
Initializable,
Serviceable {
    private static final String __CONF_FILE_PATH = "skin://conf/link-directory.xml";
    private static final String __WILDCARD = "*";
    private static final String __THEMES_CACHE = LinkDirectoryInputData.class.getName() + "$skinInputDataThemesCache";
    protected CurrentUserProvider _currentUserProvider;
    private Context _context;
    private SourceResolver _sourceResolver;
    private DirectoryHelper _directoryHelper;
    private AbstractCacheManager _cacheManager;
    private Map<String, String> _configurationError;
    private Map<String, Long> _lastConfUpdate;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void initialize() throws Exception {
        this._lastConfUpdate = new HashMap<String, Long>();
        this._configurationError = new HashMap<String, String>();
        this._cacheManager.createMemoryCache(__THEMES_CACHE, new I18nizableText("plugin.link-directory", "PLUGINS_LINK_DIRECTORY_CACHE_THEMES_LABEL"), new I18nizableText("plugin.link-directory", "PLUGINS_LINK_DIRECTORY_CACHE_THEMES_DESCRIPTION"), true, null);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public boolean isCacheable(Site site, Page currentPage) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String template = this._getTemplate(request);
        if (template == null) {
            return true;
        }
        try {
            String skinId = site.getSkinId();
            this._updateConfigurationValues(skinId);
            if (CollectionUtils.isEmpty((Collection)((Collection)this.getThemesCache().get((Object)skinId))) || this._configurationError.containsKey(skinId)) {
                return true;
            }
            String language = this._directoryHelper.getLanguage(request);
            List<ThemeInputData> themeInputDatas = this._getThemesForSkinAndTemplate(skinId, template);
            if (themeInputDatas.isEmpty()) {
                return true;
            }
            for (ThemeInputData themeInputData : themeInputDatas) {
                if (!themeInputData.isConfigurable() && !themeInputData.displayUserLinks()) continue;
                return false;
            }
            List<String> configuredThemesNames = themeInputDatas.stream().map(inputData -> this._getConfiguredThemes((ThemeInputData)inputData, language)).flatMap(Collection::stream).collect(Collectors.toList());
            String siteName = this._directoryHelper.getSiteName(request);
            return !this._directoryHelper.hasRestrictions(siteName, language, configuredThemesNames) && !this._directoryHelper.hasInternalUrl(siteName, language, configuredThemesNames);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while retrieving information from the skin configuration", (Throwable)e);
            return true;
        }
    }

    public void toSAX(ContentHandler contentHandler) throws ProcessingException {
        Request request = ContextHelper.getRequest((Context)this._context);
        UserIdentity user = this._currentUserProvider.getUser();
        String template = this._getTemplate(request);
        if (template == null) {
            this.getLogger().info("There is no current template");
            return;
        }
        String skinId = this._getSkin(request);
        if (skinId == null) {
            this.getLogger().info("There is no current skin");
            return;
        }
        try {
            this._updateConfigurationValues(skinId);
            if (CollectionUtils.isEmpty((Collection)((Collection)this.getThemesCache().get((Object)skinId)))) {
                return;
            }
            contentHandler.startDocument();
            if (this._configurationError.containsKey(skinId)) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("error", this._configurationError.get(skinId));
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"linkDirectory", (Attributes)attrs);
            } else {
                String language = this._directoryHelper.getLanguage(request);
                String siteName = this._directoryHelper.getSiteName(request);
                List<ThemeInputData> themeInputDatas = this._getThemesForSkinAndTemplate(skinId, template);
                for (ThemeInputData themeInputData : themeInputDatas) {
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("applicable", Boolean.TRUE.toString());
                    attrs.addCDATAAttribute("configurable", String.valueOf(themeInputData.isConfigurable()));
                    attrs.addCDATAAttribute("displayUserLinks", String.valueOf(themeInputData.displayUserLinks()));
                    attrs.addCDATAAttribute("id", themeInputData.getId());
                    XMLUtils.startElement((ContentHandler)contentHandler, (String)"linkDirectory", (Attributes)attrs);
                    List<String> configuredThemesNames = this._getConfiguredThemes(themeInputData, language);
                    if (configuredThemesNames != null) {
                        Map<String, List<String>> themesMap = this._directoryHelper.getThemesMap(configuredThemesNames, siteName, language);
                        List<String> correctThemesIds = themesMap.get("themes");
                        List<String> unknownThemesNames = themesMap.get("unknown-themes");
                        this._saxThemes(contentHandler, correctThemesIds, unknownThemesNames);
                        this._saxLinks(contentHandler, user, request, correctThemesIds, themeInputData.displayUserLinks(), themeInputData.isConfigurable(), themeInputData.getId());
                    }
                    XMLUtils.endElement((ContentHandler)contentHandler, (String)"linkDirectory");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("An exception occurred during the processing of the link directory's input data", (Throwable)e);
        }
    }

    private void _saxThemes(ContentHandler contentHandler, List<String> themeIds, List<String> unknownThemesNames) throws SAXException {
        if (!themeIds.isEmpty()) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"themes");
            for (String themeId : themeIds) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"theme", (String)themeId);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"themes");
        }
        if (!unknownThemesNames.isEmpty()) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("count", Integer.toString(unknownThemesNames.size()));
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"unknown-themes", (Attributes)attr, (String)StringUtils.join(unknownThemesNames, (String)", "));
        }
    }

    private void _saxLinks(ContentHandler contentHandler, UserIdentity user, Request request, List<String> themeIds, boolean displayUserLinks, boolean configurable, String specificContext) throws ProcessingException {
        String language = this._directoryHelper.getLanguage(request);
        String siteName = this._directoryHelper.getSiteName(request);
        try {
            List<DefaultLink> links = this._directoryHelper.getLinks(themeIds, siteName, language);
            List<DefaultLink> userLinks = null;
            if (user != null && displayUserLinks) {
                userLinks = this._directoryHelper.getUserLinks(siteName, language, user).stream().collect(Collectors.toList());
            }
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"links");
            try {
                String storageContext = siteName + "/" + language;
                if (StringUtils.isNotEmpty((CharSequence)specificContext)) {
                    storageContext = storageContext + "/" + specificContext;
                }
                this._directoryHelper.saxLinks(siteName, contentHandler, links, userLinks, themeIds, configurable, this._directoryHelper.getContextVars(request), storageContext, user);
            }
            catch (Exception e) {
                this.getLogger().error("An exception occurred while saxing the links", (Throwable)e);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"links");
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred while retrieving or saxing the links", (Throwable)e);
        }
    }

    private List<String> _getConfiguredThemes(ThemeInputData themeInputData, String lang) {
        return themeInputData.getThemes().stream().filter(t -> t.get("lang") == null || ((String)t.get("lang")).equals(lang)).map(t -> (String)t.get("id")).collect(Collectors.toList());
    }

    private List<ThemeInputData> _getThemesForSkinAndTemplate(String skinId, String template) {
        return ((List)this.getThemesCache().get((Object)skinId, k -> new ArrayList())).stream().filter(t -> this._filterByTemplate((ThemeInputData)t, template)).collect(Collectors.toList());
    }

    private boolean _filterByTemplate(ThemeInputData theme, String template) {
        List<String> templates = theme.getTemplates();
        return templates.contains(template) || templates.contains(__WILDCARD);
    }

    private void _updateConfigurationValues(String skinId) throws Exception {
        Source source = null;
        try {
            source = this._sourceResolver.resolveURI(__CONF_FILE_PATH);
            if (source.exists()) {
                this._cacheConfigurationValues(source, skinId, !this.getThemesCache().hasKey((Object)skinId));
            } else {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("There is no configuration file at path 'skin://conf/link-directory.xml' (no input data for link directory).");
                }
                this._lastConfUpdate.put(skinId, 0L);
                this.getThemesCache().put((Object)skinId, null);
            }
        }
        finally {
            if (this._sourceResolver != null && source != null) {
                this._sourceResolver.release(source);
            }
        }
    }

    private synchronized void _cacheConfigurationValues(Source source, String skinId, boolean forceRead) {
        long lastModified = source.getLastModified();
        if (!forceRead && this._lastConfUpdate.containsKey(skinId) && this._lastConfUpdate.get(skinId) != 0L && lastModified == this._lastConfUpdate.get(skinId)) {
            return;
        }
        ArrayList<ThemeInputData> themesCache = new ArrayList<ThemeInputData>();
        this.getLogger().info("Caching configuration");
        try {
            Configuration[] themesConfigurations;
            Configuration configuration = this._directoryHelper.getSkinLinksConfiguration(skinId);
            for (Configuration themesConfiguration : themesConfigurations = configuration.getChild("inputdata").getChildren("themes")) {
                Configuration[] themeConfigurations;
                ArrayList<Map<String, String>> themes = new ArrayList<Map<String, String>>();
                for (Configuration themeConfiguration : themeConfigurations = themesConfiguration.getChildren()) {
                    HashMap<String, String> theme = new HashMap<String, String>();
                    String id = themeConfiguration.getAttribute("id", null);
                    theme.put("id", id);
                    theme.put("lang", themeConfiguration.getAttribute("lang", null));
                    themes.add(theme);
                }
                String[] templates = StringUtils.split((String)themesConfiguration.getAttribute("templates", __WILDCARD), (char)',');
                ThemeInputData themeInputData = new ThemeInputData(themesConfiguration.getAttribute("inputDataId", ""), Arrays.asList(templates), themes, themesConfiguration.getAttributeAsBoolean("configurable", false), themesConfiguration.getAttributeAsBoolean("displayUserLinks", false));
                themesCache.add(themeInputData);
            }
            this._configurationError.remove(skinId);
            this.getThemesCache().put((Object)skinId, themesCache);
            this._lastConfUpdate.put(skinId, source.getLastModified());
        }
        catch (Exception e) {
            this.getLogger().warn("An error occured while getting the configuration's file values", (Throwable)e);
            this._configurationError.put(skinId, e.getMessage());
        }
    }

    private String _getTemplate(Request request) {
        return (String)request.getAttribute("template");
    }

    private String _getSkin(Request request) {
        return (String)request.getAttribute("skin");
    }

    private Cache<String, List<ThemeInputData>> getThemesCache() {
        return this._cacheManager.get(__THEMES_CACHE);
    }

    private static class ThemeInputData {
        private String _id;
        private List<String> _templates;
        private List<Map<String, String>> _themes;
        private boolean _configurable;
        private boolean _displayUserLinks;

        ThemeInputData(String id, List<String> templates, List<Map<String, String>> themes, boolean configurable, boolean displayUserLinks) {
            this._id = id;
            this._templates = templates;
            this._themes = themes;
            this._configurable = configurable;
            this._displayUserLinks = displayUserLinks;
        }

        boolean isConfigurable() {
            return this._configurable;
        }

        boolean displayUserLinks() {
            return this._displayUserLinks;
        }

        List<String> getTemplates() {
            return this._templates;
        }

        List<Map<String, String>> getThemes() {
            return this._themes;
        }

        String getId() {
            return this._id;
        }
    }
}

