/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.BinarySource;
import org.ametys.core.util.FilenameUtils;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;

public class LinkSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe,
Serviceable {
    public static final String SCHEME = "link";
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        String uri = location.substring("link://".length());
        int i = uri.indexOf(124);
        int j = uri.indexOf(59, i);
        String path = uri.substring(0, i);
        String attribute = uri.substring(i + 1, j);
        String filename = uri.substring(j + 1);
        try {
            DefaultLink link = (DefaultLink)this._resolver.resolveByPath(FilenameUtils.decode((String)path));
            Binary binary = (Binary)link.getValue(attribute);
            return new BinarySource(binary, FilenameUtils.decode((String)filename), location, SCHEME);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to resolve binary attribute for uri " + location, (Throwable)e);
            return new BinarySource(null, FilenameUtils.decode((String)filename), location, SCHEME);
        }
    }

    public void release(Source source) {
    }
}

