/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.repository;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.data.Binary;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.repository.DefaultLinkFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.MovableAmetysObject;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultLink
extends DefaultTraversableAmetysObject<DefaultLinkFactory>
implements Link,
SiteAwareAmetysObject,
MovableAmetysObject,
ModifiableModelLessDataAwareAmetysObject {
    public static final String PROPERTY_URL = "ametys-internal:url";
    public static final String PROPERTY_DYNAMIC_INFO_PROVIDER = "ametys-internal:dynamic-information";
    public static final String PROPERTY_INTERNAL_URL = "ametys-internal:internal-url";
    public static final String PROPERTY_URLTYPE = "ametys-internal:url-type";
    public static final String PROPERTY_TITLE = "ametys-internal:title";
    public static final String PROPERTY_CONTENT = "ametys-internal:content";
    public static final String PROPERTY_URL_ALTERNATIVE = "ametys-internal:url-alternative";
    public static final String PROPERTY_PICTURE_TYPE = "ametys-internal:picture-type";
    public static final String PROPERTY_PICTURE = "picture";
    public static final String PROPERTY_PICTURE_ID = "ametys-internal:picture-id";
    public static final String PROPERTY_PICTURE_GLYPH = "ametys-internal:picture-glyph";
    public static final String PROPERTY_PICTURE_ALTERNATIVE = "ametys-internal:picture-alternative";
    public static final String PROPERTY_THEMES = "ametys-internal:themes";
    public static final String PROPERTY_COLOR = "ametys-internal:color";
    public static final String PROPERTY_PAGE = "ametys-internal:page";
    public static final String PROPERTY_STATUS = "ametys-internal:status";
    public static final String PROPERTY_DEFAULT_VISIBILITY = "ametys-internal:default-visibility";

    public DefaultLink(Node node, String parentPath, DefaultLinkFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    @Override
    public String getUrl() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_URL).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the URL property.", (Throwable)e);
        }
    }

    @Override
    public void setUrl(Link.LinkType urlType, String url) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_URLTYPE, urlType.toString());
            this.getNode().setProperty(PROPERTY_URL, url);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the URL property.", (Throwable)e);
        }
    }

    @Override
    public String getInternalUrl() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_INTERNAL_URL).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the internal URL property.", (Throwable)e);
        }
    }

    @Override
    public void setInternalUrl(String url) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_INTERNAL_URL, url);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the internal URL property.", (Throwable)e);
        }
    }

    @Override
    public Link.LinkType getUrlType() throws AmetysRepositoryException {
        try {
            return Link.LinkType.valueOf(this.getNode().getProperty(PROPERTY_URLTYPE).getString());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get URL type property", (Throwable)e);
        }
    }

    @Override
    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the title property.", (Throwable)e);
        }
    }

    @Override
    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the title property.", (Throwable)e);
        }
    }

    @Override
    public String getContent() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_CONTENT).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the content property.", (Throwable)e);
        }
    }

    @Override
    public void setContent(String content) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_CONTENT, content);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the content property.", (Throwable)e);
        }
    }

    @Override
    public String getAlternative() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_URL_ALTERNATIVE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public void setAlternative(String alternative) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_URL_ALTERNATIVE, alternative);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public Binary getExternalPicture() throws AmetysRepositoryException {
        return (Binary)this.getValue(PROPERTY_PICTURE);
    }

    @Override
    public void setExternalPicture(String mimeType, String filename, InputStream stream) throws AmetysRepositoryException {
        try {
            this.removePictureMetas();
            this.setPictureType("external");
            Binary pic = new Binary();
            pic.setLastModificationDate(ZonedDateTime.now());
            pic.setInputStream(stream);
            pic.setMimeType(mimeType);
            pic.setFilename(filename);
            this.setValue(PROPERTY_PICTURE, pic);
        }
        catch (IOException | RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the external picture property.", e);
        }
    }

    @Override
    public String getResourcePictureId() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_ID).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the picture ID property.", (Throwable)e);
        }
    }

    @Override
    public void setResourcePicture(String resourceId) throws AmetysRepositoryException {
        try {
            this.removePictureMetas();
            this.setPictureType("resource");
            this.getNode().setProperty(PROPERTY_PICTURE_ID, resourceId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public void setNoPicture() throws AmetysRepositoryException {
        try {
            this.setPictureType("");
            this.removePictureMetas();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public String getPictureType() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_TYPE).getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the type property.", (Throwable)e);
        }
    }

    @Override
    public void setPictureType(String type) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_PICTURE_TYPE, type);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the type property.", (Throwable)e);
        }
    }

    @Override
    public String getPictureGlyph() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_GLYPH).getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the picture glyph property.", (Throwable)e);
        }
    }

    @Override
    public void setPictureGlyph(String glyph) throws AmetysRepositoryException {
        try {
            this.setPictureType("glyph");
            this.getNode().setProperty(PROPERTY_PICTURE_GLYPH, glyph);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the picture glyph property.", (Throwable)e);
        }
    }

    @Override
    public String getPictureAlternative() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PICTURE_ALTERNATIVE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public void setPictureAlternative(String alternative) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_PICTURE_ALTERNATIVE, alternative);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the alternative property.", (Throwable)e);
        }
    }

    @Override
    public String[] getThemes() throws AmetysRepositoryException {
        return this._getListFromMetadataName(PROPERTY_THEMES);
    }

    @Override
    public void setThemes(String[] themes) throws AmetysRepositoryException {
        this._setListWithMetadataName(themes, PROPERTY_THEMES);
    }

    @Override
    public void removeTheme(String themeId) throws AmetysRepositoryException {
        try {
            Object[] themes = this.getThemes();
            String[] updatedThemes = (String[])ArrayUtils.removeElement((Object[])themes, (Object)themeId);
            this.getNode().setProperty(PROPERTY_THEMES, updatedThemes);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error removing theme of id " + themeId, (Throwable)e);
        }
    }

    public Site getSite() throws AmetysRepositoryException {
        for (AmetysObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Site)) continue;
            return (Site)parent;
        }
        return null;
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getSite().getName();
    }

    public String getLanguage() {
        return this.getParent().getParent().getName();
    }

    protected void removePictureMetas() throws RepositoryException {
        this.getNode().setProperty(PROPERTY_PICTURE_ID, "");
        this.removeValue(PROPERTY_PICTURE);
    }

    public void orderBefore(AmetysObject siblingObject) throws AmetysRepositoryException {
        if (siblingObject instanceof DefaultLink) {
            DefaultLink sibling = (DefaultLink)siblingObject;
            sibling.getPath();
            Node node = this.getNode();
            String siblingPath = "";
            try {
                String path;
                siblingPath = sibling.getNode().getPath();
                if (siblingPath.contains("/")) {
                    siblingPath = StringUtils.substringAfterLast((String)siblingPath, (String)"/");
                }
                if ((path = node.getPath()).contains("/")) {
                    path = StringUtils.substringAfterLast((String)path, (String)"/");
                }
                node.getParent().orderBefore(path, siblingPath);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(String.format("Unable to order link '%s' before link '%s'", this, siblingPath), (Throwable)e);
            }
        } else {
            throw new AmetysRepositoryException("A link can only be moved before another link.");
        }
    }

    public void moveTo(AmetysObject newParent, boolean renameIfExist) throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        if (this.getParent().equals((Object)newParent)) {
            try {
                Node node = this.getNode();
                String path = node.getPath();
                if (path.contains("/")) {
                    path = StringUtils.substringAfterLast((String)path, (String)"/");
                }
                node.getParent().orderBefore(path, null);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(String.format("Unable to move link '%s' outside the root link node.", this), (Throwable)e);
            }
        } else {
            throw new AmetysRepositoryException("A link can only be moved before another link.");
        }
    }

    public boolean canMoveTo(AmetysObject newParent) throws AmetysRepositoryException {
        return this.getParent().equals((Object)newParent);
    }

    private String[] _getListFromMetadataName(String metadataName) {
        try {
            if (this.getNode().hasProperty(metadataName)) {
                Value[] values = this.getNode().getProperty(metadataName).getValues();
                String[] list = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    list[i] = values[i].getString();
                }
                return list;
            }
            return new String[0];
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occurred while trying to get the property '" + metadataName + "'.", (Throwable)e);
        }
    }

    private void _setListWithMetadataName(String[] list, String metadataName) {
        try {
            this.getNode().setProperty(metadataName, list);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occurred while trying to set the property '" + metadataName + "'.", (Throwable)e);
        }
    }

    @Override
    public String getDynamicInformationProvider() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_DYNAMIC_INFO_PROVIDER).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the URL property.", (Throwable)e);
        }
    }

    @Override
    public void setDynamicInformationProvider(String providerId) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_DYNAMIC_INFO_PROVIDER, providerId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the URL property.", (Throwable)e);
        }
    }

    @Override
    public String getColor() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_COLOR).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the color property.", (Throwable)e);
        }
    }

    @Override
    public void setColor(String color) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_COLOR, color);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the color property.", (Throwable)e);
        }
    }

    @Override
    public String getPage() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_PAGE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the page property.", (Throwable)e);
        }
    }

    @Override
    public void setPage(String page) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_PAGE, page);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the page property.", (Throwable)e);
        }
    }

    @Override
    public Link.LinkStatus getStatus() throws AmetysRepositoryException {
        try {
            return Link.LinkStatus.valueOf(this.getNode().getProperty(PROPERTY_STATUS).getString());
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the status property.", (Throwable)e);
        }
    }

    @Override
    public void setStatus(Link.LinkStatus status) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_STATUS, status.name());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the status property.", (Throwable)e);
        }
    }

    @Override
    public Link.LinkVisibility getDefaultVisibility() throws AmetysRepositoryException {
        try {
            Node node = this.getNode();
            if (node.hasProperty(PROPERTY_DEFAULT_VISIBILITY)) {
                return Link.LinkVisibility.valueOf(this.getNode().getProperty(PROPERTY_DEFAULT_VISIBILITY).getString());
            }
            return Link.LinkVisibility.VISIBLE;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the visibility property.", (Throwable)e);
        }
    }

    @Override
    public void setDefaultVisibility(Link.LinkVisibility visibility) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(PROPERTY_DEFAULT_VISIBILITY, visibility.name());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the visibility property.", (Throwable)e);
        }
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder((ModelItemTypeExtensionPoint)((DefaultLinkFactory)this._getFactory()).getLinkDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }
}

