/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.right;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractProfileStorageBasedAccessController;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class LinkDirectoryAccessController
extends AbstractProfileStorageBasedAccessController
implements Contextualizable {
    public static final I18nizableText LINK_DIRECTORY_CONTEXT_CATEGORY = new I18nizableText("plugin.link-directory", "PLUGINS_LINKDIRECTORY_LINKDIRECTORY_RIGHT_ASSIGNMENT_CONTEXT_LABEL");
    protected DirectoryHelper _directoryHelper;
    protected SiteManager _siteManager;
    protected CurrentUserProvider _currentUserProvider;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public boolean supports(Object object) {
        return object instanceof Link;
    }

    protected boolean ignoreOnHasAnyPermission() {
        return true;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        Site site = this._siteManager.getSite(siteName);
        if (site != null) {
            UserIdentity user = this._currentUserProvider.getUser();
            HashSet<ModifiableTraversableAmetysObject> roots = new HashSet<ModifiableTraversableAmetysObject>();
            try (AmetysObjectIterable sitemaps = site.getSitemaps();){
                for (Sitemap sitemap : sitemaps) {
                    roots.add(this._directoryHelper.getLinksNode(site, sitemap.getName()));
                    if (user == null) continue;
                    roots.add(this._directoryHelper.getLinksForUserNode(site, siteName, user));
                }
            }
            return roots;
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        return new I18nizableText("plugin.link-directory", "PLUGINS_LINKDIRECTORY_LINK_ACCESS_CONTROLLER_LINK_CONTEXT_LABEL", Map.of("title", this.getObjectLabel(object)));
    }

    public I18nizableText getObjectLabel(Object object) throws RightsException {
        if (object instanceof DefaultLink) {
            DefaultLink link = (DefaultLink)object;
            String title = link.getTitle();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                return new I18nizableText(link.getLanguage().toUpperCase() + " > " + title + " (" + link.getUrl() + ")");
            }
            return new I18nizableText(link.getLanguage().toUpperCase() + " > " + link.getUrl());
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return LINK_DIRECTORY_CONTEXT_CATEGORY;
    }
}

