/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.theme;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.jcr.AbstractJCRTagProvider;
import org.ametys.plugins.linkdirectory.theme.ThemeJCR;
import org.ametys.plugins.linkdirectory.theme.ThemeProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class JCRThemeProvider
extends AbstractJCRTagProvider<DefaultTag> {
    public static final String LINKDIRECTORY_PLUGIN_NODE_NAME = "linkdirectory";
    protected AmetysObjectResolver _resolver;
    protected ThemeProviderExtensionPoint _themeProviderEP;
    protected SiteManager _siteManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._themeProviderEP = (ThemeProviderExtensionPoint)((Object)smanager.lookup(ThemeProviderExtensionPoint.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
    }

    protected void _fillCache(TraversableAmetysObject parentTagNode, DefaultTag parentTag, Map<String, DefaultTag> cache) throws RepositoryException {
        for (AmetysObject child : parentTagNode.getChildren()) {
            if (!(child instanceof ThemeJCR)) continue;
            ThemeJCR jcrTag = (ThemeJCR)child;
            DefaultTag tag = new DefaultTag(jcrTag.getId(), jcrTag.getName(), parentTag, new I18nizableText(jcrTag.getTitle()), new I18nizableText(jcrTag.getDescription()));
            cache.put(child.getName(), tag);
            if (parentTag != null) {
                parentTag.addTag((Tag)tag);
            }
            this._fillCache((TraversableAmetysObject)jcrTag, tag, cache);
        }
    }

    protected Map<String, DefaultTag> _getCache(Map<String, Object> contextualParameters) throws RepositoryException {
        HashMap<String, DefaultTag> siteCache;
        Request request = ContextHelper.getRequest((Context)this._context);
        if (request == null) {
            return new HashMap<String, DefaultTag>();
        }
        String siteName = (String)contextualParameters.get("siteName");
        HashMap<String, HashMap<String, DefaultTag>> cache = (HashMap<String, HashMap<String, DefaultTag>>)request.getAttribute(CACHE_REQUEST_ATTRIBUTE + "$" + this.getId());
        if (cache == null) {
            cache = new HashMap<String, HashMap<String, DefaultTag>>();
            request.setAttribute(CACHE_REQUEST_ATTRIBUTE + "$" + this.getId(), cache);
        }
        if ((siteCache = (HashMap<String, DefaultTag>)cache.get(siteName)) == null) {
            siteCache = new HashMap<String, DefaultTag>();
            ModifiableTraversableAmetysObject rootNode = this.getRootNode(contextualParameters);
            this._fillCache((TraversableAmetysObject)rootNode, null, siteCache);
            cache.put(siteName, siteCache);
        }
        return siteCache;
    }

    protected ModifiableTraversableAmetysObject _getRootNode(Map<String, Object> contextualParameters, Session session) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginNode;
        String siteName = (String)contextualParameters.get("siteName");
        String language = (String)contextualParameters.get("language");
        Map user = (Map)contextualParameters.get("user");
        String locale = null;
        if (user != null) {
            locale = (String)user.get("locale");
        }
        if (StringUtils.isBlank((CharSequence)siteName)) {
            try {
                ModifiableTraversableAmetysObject pluginNode2;
                ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins", session);
                ModifiableTraversableAmetysObject parentNode = pluginNode2 = this._getOrCreateNode(pluginsNode, LINKDIRECTORY_PLUGIN_NODE_NAME, "ametys:unstructured");
                if (StringUtils.isNotBlank((CharSequence)language)) {
                    parentNode = this._getOrCreateNode(pluginNode2, language, "ametys:unstructured");
                }
                return this._getOrCreateNode(parentNode, this._themeProviderEP.getTagsNodeName(), this._themeProviderEP.getTagsNodeType());
            }
            catch (AmetysRepositoryException e) {
                throw new AmetysRepositoryException("Unable to get the JCR tags root node", (Throwable)e);
            }
        }
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName, session).getRootPlugins();
        ModifiableTraversableAmetysObject parentNode = pluginNode = this._getOrCreateNode(pluginsNode, LINKDIRECTORY_PLUGIN_NODE_NAME, "ametys:unstructured");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            parentNode = this._getOrCreateNode(pluginNode, language, "ametys:unstructured");
        } else if (StringUtils.isNotBlank((CharSequence)locale)) {
            parentNode = this._getOrCreateNode(pluginNode, locale, "ametys:unstructured");
        }
        return this._getOrCreateNode(parentNode, this._themeProviderEP.getTagsNodeName(), this._themeProviderEP.getTagsNodeType());
    }

    public Collection<DefaultTag> getTags(String tagID, Map<String, Object> contextualParameters) {
        DefaultTag tag = (DefaultTag)this.getTag(tagID, contextualParameters);
        return tag != null ? tag.getTags().values() : null;
    }
}

