<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl math resolver ametys">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:link-directory://pages/services/directory/utils/config_utils.xsl"/> 

    <xsl:param name="header" select="string(ametys:serviceParameter('header'))"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="raw-is-title-visible">        
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:variable>    
    <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
    <xsl:variable name="level">
        <xsl:choose>
            <xsl:when test="$is-title-visible">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}"></script>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">link-directory linkdirectory-default</xsl:variable>
    <xsl:variable name="is-empty" select="not(/links/link)"/> 
    <xsl:variable name="common-service-name-id">service-linkdirectory</xsl:variable>    
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                  
        </xsl:call-template>
    </xsl:template>  
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="display-configure-links-btn-service">
            <xsl:with-param name="maxCheckedLinks" select="32"/>
            <xsl:with-param name="height" select="30"/>
            <xsl:with-param name="width" select="30"/>
        </xsl:call-template>
        
        <xsl:call-template name="display-add-user-link-btn-service"/>
        
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
        
        <xsl:call-template name="unknown-themes">
            <xsl:with-param name="count" select="/links/unknown-themes/@count"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-empty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <p>
                <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SERVICE_NO_ENTRY"/>
            </p>
        </div>      
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        
        <div id="link-directory-{$uniqueId}">
        	<xsl:attribute name="class">link-directory-body<xsl:if test="/links/link/@pictureType != ''"><xsl:text> pictures</xsl:text></xsl:if></xsl:attribute>
            <ul class="links">
                <xsl:apply-templates select="/links/link[not(@unknownPage)]">
                    <xsl:sort select="@user-selected='true'" order="descending"/>
                </xsl:apply-templates>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="link[@url != '' and @isHidden = 'false']">
        <li>
            <xsl:choose>
                <xsl:when test="@disabled">
                    <xsl:attribute name="class">link <xsl:call-template name="common-utils-class"/> link-disabled</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">link <xsl:call-template name="common-utils-class"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:call-template name="link-picture"/>
            
            <div class="link-infos">
                <xsl:call-template name="link-url"/>
                
                <xsl:call-template name="link-description"/>
                
                <xsl:if test="ametys:serviceParameter('showThemes') = 'true'">
                    <xsl:call-template name="link-themes"/>
                </xsl:if>
            </div>
            
            <div class="link-end"/>
        </li>
    </xsl:template>
    
    <xsl:template name="link-picture">
    	<xsl:if test="@pictureType != '' and (@pictureId or @picturePath or @pictureGlyph)">
	    	<div class="link-picture">
                <a onclick="window.open(this.href); return false;" >
                    <xsl:attribute name="href">
                        <xsl:choose>
                            <xsl:when test="@urlType = 'PAGE'"><xsl:value-of select="resolver:resolve('page', @url)"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:call-template name="link-status" />
                    <xsl:if test="normalize-space(@title) != ''">
                        <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
                    </xsl:if>
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'glyph'">
                            <span class="link-glyph {@pictureGlyph}" style="font-size: 100px; color:{@color}"></span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="id">
                                <xsl:choose>
                                    <xsl:when test="@pictureType = 'resource'">
                                        <xsl:value-of select="@pictureId"/>
                                    </xsl:when>
                                    <xsl:when test="@pictureType = 'external'">
                                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:variable>
                                <img src="{resolver:resolveBoundedImage(@imageType, $id, 100, 100)}">
                                    <xsl:attribute name="alt"><xsl:value-of select="@pictureAlternative"/></xsl:attribute>
                                </img>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
	        </div>
		 </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-url">
    	<div class="link-text">
          	<xsl:choose>
          		<xsl:when test="ametys:serviceParameter('showUrl') = 'true' and normalize-space(@title) != ''">
          			<span class="label"><xsl:value-of select="@title"/></span>
                    <xsl:choose>
                        <xsl:when test="@urlType = 'PAGE'">
                            <a href="{resolver:resolve('page', @url)}" title="{@alternative}">
                            	<xsl:call-template name="link-status" />
                                <xsl:choose>
                            		<xsl:when test="$rendering-context = 'back'">
                            			<xsl:variable name="pageSiteName" select="ametys:pageSiteName(@url)"/>
		                            	<xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($pageSiteName), '/', ametys:lang(@url), '/', ametys:pagePath(@url), '.html')"/>
                            		</xsl:when>
                            		<xsl:otherwise>
                            			<xsl:value-of select="resolver:resolve('page', @url, false(), true())"></xsl:value-of>
                            		</xsl:otherwise>
                            	</xsl:choose>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="@disabled">
                                   <span>
                                     <xsl:value-of select="@url"/>
                                   </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a onclick="window.open(this.href); return false;" href="{@url}" title="{@alternative}">
                                        <xsl:call-template name="link-status" />
	                                    <xsl:value-of select="@url"/>
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
          		</xsl:when>
          		<xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="@urlType = 'PAGE'">
                            <a href="{resolver:resolve('page', @url)}" title="{@alternative}">
                                <xsl:call-template name="link-status" />
                                <xsl:choose>
                                    <xsl:when test="normalize-space(@title) != ''"><xsl:value-of select="@title"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="@pageTitle"/></xsl:otherwise>
                                </xsl:choose>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="@disabled">
                                    <span>
                                    <xsl:choose>
                                        <xsl:when test="normalize-space(@title) != ''"><xsl:value-of select="@title"/></xsl:when>
                                        <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
                                    </xsl:choose>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
		                            <a onclick="window.open(this.href); return false;" href="{@url}" title="{@alternative}">
		                               <xsl:call-template name="link-status" />
				                       <xsl:choose>
				                           <xsl:when test="normalize-space(@title) != ''"><xsl:value-of select="@title"/></xsl:when>
				                           <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
				                       </xsl:choose>
				                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
          		</xsl:otherwise>
          	</xsl:choose>
		</div>
    </xsl:template>
    
    <xsl:template name="link-description">
    	<xsl:if test="@content != ''">
	    	<div class="link-description">
	    		<p>
		    		<xsl:call-template name="text.nl2br">
						<xsl:with-param name="input" select="@content"/>
				    </xsl:call-template>
			    </p>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="link-themes">
    	<xsl:if test="themes/theme">
           <div class="link-themes">
	           	<p>
	        		<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SERVICE_DISPLAY_THEMES"/>
	        	</p>
	        	<ul>
	        		<xsl:for-each select="themes/theme">
	        			<li>
	        				<xsl:value-of select="label"/>
	        				<xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
	        			</li>
	        		</xsl:for-each>
	       		</ul>
	       	</div>
       	</xsl:if>
    </xsl:template>
    
    <xsl:template name="link-status">
        <xsl:choose>
            <xsl:when test="@status = 'BROKEN'">
                <xsl:attribute name="class">broken</xsl:attribute>
            </xsl:when>
            <xsl:when test="@status = 'NEW'">
                <xsl:attribute name="class">new</xsl:attribute>
                <xsl:attribute name="data-new-message">PLUGINS_LINKDIRECTORY_NEW_MESSAGE</xsl:attribute>
                <xsl:attribute name="i18n:attr">data-new-message</xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
