<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math resolver ametys">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:link-directory://pages/services/directory/utils/config_utils.xsl"/> 
    <xsl:import href="service:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/> 
    
    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Max number of links displayed before a "See more" button appears -->    
    <xsl:variable name="moreThreshold" select="8"/>
        
    <xsl:variable name="raw-is-title-visible">        
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:variable>    
    <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
    <xsl:variable name="level">
        <xsl:choose>
            <xsl:when test="$is-title-visible">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">link-directory linkdirectory-thumbnails</xsl:variable>
    <xsl:variable name="is-empty" select="not(/links/link)"/> 
    <xsl:variable name="common-service-name-id">service-linkdirectory-thumbnails</xsl:variable>    
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                  
        </xsl:call-template>
    </xsl:template>  
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}"></script>
    
        <xsl:call-template name="link-dynamic-info-js">
            <xsl:with-param name="themes" select="ametys:serviceParameter('themes')"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        
        <!-- Display the configure links button if the service is configurable -->
        <xsl:call-template name="display-configure-links-btn-service">
	        <xsl:with-param name="maxCheckedLinks" select="$moreThreshold - 1"/>
        </xsl:call-template>
        
        <!-- Display the 'add user link' button if the service displays user links -->
        <xsl:call-template name="display-add-user-link-btn-service"/>
        
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    

        <!-- Display an error if the selected themes are invalid -->
        <xsl:call-template name="unknown-themes">
            <xsl:with-param name="count" select="/links/unknown-themes/@count"/>
        </xsl:call-template>
        
    </xsl:template>
    
    <xsl:template name="common-service-body-empty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            <p>
                <i18n:text i18n:key="PLUGINS_LINKDIRECTORY_SERVICE_NO_ENTRY"/>
            </p>
        </div>      
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <!-- Display the links in thumbnails mode -->
        <xsl:call-template name="links-thumbnails">
            <xsl:with-param name="links" select="/links/link"/>
            <xsl:with-param name="moreThreshold" select="$moreThreshold"/>
            <xsl:with-param name="height" select="100"/>
            <xsl:with-param name="width" select="100"/>
            <xsl:with-param name="showThemes" select="ametys:serviceParameter('showThemes')/text()"/>
            <xsl:with-param name="showUrl" select="ametys:serviceParameter('showUrl')/text()"/>
        </xsl:call-template>
           
    </xsl:template>
    
</xsl:stylesheet>
