/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Helper for link directory
 */
var AmetysHelperLinkDirectory = {
	
	/**
     * Save user preference for user directory 
     * @param {Array} orderedLinks The ordered links list to save. If null, we ignore this user preference. If empty, we set the ordered links user preference to empty.
     * @param {Array} hiddenLinks The hidden links list to save. If null, we ignore this user preference. If empty, we set the hidden links user preference to empty.
     * @param {String} siteUriPrefix the site uri prefix
     * @param {String} lang the current language
     * @param {String} savingId the saving id, it can be the zone item id or input data id and it can be empty for default input data (the user pref depend of this unique id)
     * @param {Function} successCB the function which be called if saving the user preference works
     * @param {Function} errorCB the function which be called if an error occurred saving the user preference
     */
	saveUserPrefs: function(orderedLinks, hiddenLinks, siteUriPrefix, lang, savingId, successCB, errorCB)
	{   
	    var data = {
	        'saving-id': savingId,
            'language': lang
	    };
	    
	    if (orderedLinks != null)
	    {
	    	data['ordered-links'] = orderedLinks.join();
	    }
	    
	    if (hiddenLinks != null)
	    {
	    	data['hidden-links'] = hiddenLinks.join();
	    }
	    
	    $j.ajax({
	        url: siteUriPrefix + '/_plugins/link-directory/set-user-preferences',
	        data: data,
	        method: 'POST',
	        success: function(data) { 
	        	if ($j.isFunction(successCB))
	        	{
	        		successCB();
	        	}
	    	},
	        error: function(data) {
	        	if ($j.isFunction(errorCB))
	        	{
	        		errorCB();
	        	}
	    	}
	    });
	},

	/**
     * Remove a list of user link 
     * @param {Array} linksToRemove The list of user links to remove. If null, we do nothing. If empty, the noLinkToRemoveCB will be called.
     * @param {String} siteUriPrefix the site uri prefix
     * @param {Function} successCB the function which be called if deleting the user links works
     * @param {Function} errorCB the function which be called if an error occurred deleting the user links
     * @param {Function} noLinkToRemoveCB the function which be called if there are no user link to remove
     */
	removeUserLinks: function(linksToRemove, siteUriPrefix, successCB, errorCB, noLinkToRemoveCB)
	{
		if (linksToRemove != null)
		{
		    if (linksToRemove.length > 0)
		    {
		        $j.ajax({
		            url: siteUriPrefix + '/_plugins/link-directory/remove-user-link',
		            data: {
		                ids: JSON.stringify(linksToRemove)
		            },
		            method: 'POST',
		            success: function(data) {
		            	if ($j.isFunction(successCB))
			        	{
			        		successCB();
			        	}
		            },
		            error: function(data) {
		            	if ($j.isFunction(errorCB))
			        	{
		            		errorCB();
			        	}
		            }
		        });
		    }
		    else
		    {
		    	if ($j.isFunction(noLinkToRemoveCB))
	        	{
		    		noLinkToRemoveCB();
	        	}
		    }
		}
    }
}