/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.dynamic;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.core.util.IgnoreRootHandler;

/**
 * Ignore root handler that remove the 'dynamic-information' root tag
 */
public class DynamicInformationHandler extends IgnoreRootHandler
{
    private static final String __DYNAMIC_INFO_ROOT_TAG = "dynamic-information";
    
    private ContentHandler _contentHandler;

    /**
     * Create a handler
     * @param contentHandler The handler to wrap
     */
    public DynamicInformationHandler(ContentHandler contentHandler)
    {
        super(contentHandler);
        _contentHandler = contentHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException
    {
        if (!qName.equals(__DYNAMIC_INFO_ROOT_TAG))
        {
            _contentHandler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException
    {
        if (!qName.equals(__DYNAMIC_INFO_ROOT_TAG))
        {
            _contentHandler.endElement(uri, localName, qName);
        }
    }
}
